// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

#include <Physics2012/Dynamics/Entity/hkpEntity.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>


class hkpRigidBody;

    /// Makes a surface a little slippery (like thick oil or tar).
    /// It allows for removing objects which got stuck in a narrow gap.
    /// Typical applications include cars getting stuck between two buildings.
    /// Note: you have to call makeSurfaceViscose before you add the entity to the world.
    /// Note: this class only works if the default hkpSimpleConstraintContactMgr is used
class HK_EXPORT_PHYSICS_2012 hkpViscoseSurfaceUtil: public hkReferencedObject, private hkpContactListener, private hkpEntityListener
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

            /// Creates a handle to a surface velocity
        static inline void HK_CALL makeSurfaceViscose(hkpRigidBody* entity);

    protected:
        hkpViscoseSurfaceUtil( hkpRigidBody* entity );

        // The contact listener interface.

        void contactPointCallback( const hkpContactPointEvent& event );

        // The hkpEntityListener interface implementation

        void entityDeletedCallback( hkpEntity* entity );

        //
        // For internal use
        //
    public:
        hkpEntity*   m_entity;
};

void HK_CALL hkpViscoseSurfaceUtil::makeSurfaceViscose(hkpRigidBody* entity)
{
    new hkpViscoseSurfaceUtil( entity );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
