// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

#include <Physics2012/Dynamics/Entity/hkpEntity.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>

class hkpRigidBody;

    /// A listener class used to soften collisions.
    ///
    /// The utility scales the forces applied between bodies during collision resolution. This results in softened collisions and contact.
    /// Note that this utility should not be used for pairs of bodies between which continuous collision detection and response is performed,
    /// as this might significantly impact simulations performance.
    /// This feature is currently beta - use it with care.
class HK_EXPORT_PHYSICS_2012 hkpSoftContactUtil: public hkReferencedObject, private hkpContactListener, private hkpEntityListener
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

            /// Adds the soft contact util as a listener to bodyA.
            ///
            /// If a contact point is added between bodyA and bodyB, the forces applied between the bodies are changed.
            /// This may be used to achieve soft contacts.
            /// If bodyB is set to NULL, than bodyA will get soft contacts with all bodies
        hkpSoftContactUtil( hkpRigidBody* bodyA, hkpRigidBody* optionalBodyB, hkReal forceScale, hkReal maxAccel );

        ~hkpSoftContactUtil();

    protected:

        void contactPointCallback( const hkpContactPointEvent& event );

        void entityDeletedCallback( hkpEntity* entity );

        //
        //  Internal public section
        //
    protected:
        hkpRigidBody* m_bodyA;
        hkpRigidBody* m_bodyB;

    public:
        hkReal m_forceScale;
        hkReal m_maxAcceleration;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
