// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Common/Base/hkBase.h>
#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>
#include <Physics2012/Dynamics/Entity/hkpEntity.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>

class hkpRigidBody;

/// This listener class can be used to virtually change the center of mass of objects during collision.
///
/// By calling setCenterOfMassForContact() in hkpResponseModifier this allows an object to
/// interact differently with one object than with another.
/// This utility is an entity listener and uses 2 rigid bodies to decide when to
/// change the center of mass and how to change it. You may implement a world listener
/// and a look-up table to change the response of any object in contact with any
/// other object.
class HK_EXPORT_PHYSICS_2012 hkpCenterOfMassChangerUtil: public hkReferencedObject, private hkpContactListener, private hkpEntityListener
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

            /// Adds the hkpCenterOfMassChangerUtil as a listener to bodyA.
            /// If a contact point is added between bodyA and bodyB, the center of mass is displaced for each body.
            /// The displacement vector specifies displacement in the body's local space.
        hkpCenterOfMassChangerUtil( hkpRigidBody* bodyA, hkpRigidBody* bodyB, const hkVector4& displacementA, const hkVector4& displacementB );

        ~hkpCenterOfMassChangerUtil();

    protected:

        void contactPointCallback( const hkpContactPointEvent& event );

            // The hkpEntityListener interface implementation
        void entityDeletedCallback( hkpEntity* entity );


    protected:

        hkpRigidBody* m_bodyA;
        hkpRigidBody* m_bodyB;
        hkVector4 m_displacementA;
        hkVector4 m_displacementB;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
