// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Utilities/CharacterControl/StateMachine/hkpCharacterState.h>
#include <Physics2012/Utilities/CharacterControl/StateMachine/hkpCharacterStateManager.h>

hkpCharacterStateManager::hkpCharacterStateManager()
{
    for (int i=0; i < HK_CHARACTER_MAX_STATE_ID; i++)
    {
        m_registeredState[i] = HK_NULL;
    }
}

hkpCharacterStateManager::~hkpCharacterStateManager()
{
    for (int i=0; i < HK_CHARACTER_MAX_STATE_ID; i++)
    {
        if (m_registeredState[i] != HK_NULL)
        {
            m_registeredState[i]->removeReference();
            m_registeredState[i] = HK_NULL;
        }
    }
}

void hkpCharacterStateManager::registerState(hkpCharacterState* state, hkpCharacterStateType stateType)
{
    state->addReference();

    hkpCharacterState* oldState = m_registeredState[stateType];

    if (oldState != HK_NULL)
    {
        oldState->removeReference();
    }

    m_registeredState[stateType] = state;
}

hkpCharacterState* hkpCharacterStateManager::getState(hkpCharacterStateType stateType) const
{
    return m_registeredState[stateType];
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
