// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/hkBase.h>

class hkpCharacterContext;
struct hkpCharacterInput;
struct hkpCharacterOutput;

/// The character state types.
enum hkpCharacterStateType
{
    // default states
    HK_CHARACTER_ON_GROUND = 0,
    HK_CHARACTER_JUMPING,
    HK_CHARACTER_IN_AIR,
    HK_CHARACTER_CLIMBING,
    HK_CHARACTER_FLYING,

    // user states
    HK_CHARACTER_USER_STATE_0,
    HK_CHARACTER_USER_STATE_1,
    HK_CHARACTER_USER_STATE_2,
    HK_CHARACTER_USER_STATE_3,
    HK_CHARACTER_USER_STATE_4,
    HK_CHARACTER_USER_STATE_5,

    HK_CHARACTER_MAX_STATE_ID
};


/// This class represents the behaviour for a typical character state.
/// The state machine is built implicitly from a collection of states.
/// Most of the real work is done in the update call where the state performs actions
/// and transitions to other states through a given character context.
class HK_EXPORT_PHYSICS_2012 hkpCharacterState : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CHARACTER);

            /// Return the state type
        virtual hkpCharacterStateType getType() const = 0;

            /// Do something before we transition to this state
        virtual void enterState( hkpCharacterContext& context, hkpCharacterStateType prevState, const hkpCharacterInput& input, hkpCharacterOutput& output );

            /// Do something before we leave this state
        virtual void leaveState( hkpCharacterContext& context, hkpCharacterStateType nextState, const hkpCharacterInput& input, hkpCharacterOutput& output );

            /// Process the input - causes only state actions
        virtual void update( hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output ) = 0;

            /// Process the input - causes only state transitions
        virtual void change( hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output ) = 0;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
