// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Utilities/CharacterControl/StateMachine/hkpCharacterState.h>

/// A jumping state.
/// During update this state adjusts the upward velocity based on current world gravity.
/// The character remains in this state for an extra frame, and then transitions to the InAir state.
/// This is to make sure the character is clear of the ground when the character enters the inAir state:
/// if the character is not clear of the ground, it will transition back to onGround, and groundHugging
/// will kill the upwards velocity of the jump.
class HK_EXPORT_PHYSICS_2012 hkpCharacterStateJumping : public hkpCharacterState
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        hkpCharacterStateJumping();

            /// Return the state type
        virtual hkpCharacterStateType getType() const;

            /// Process the user input - causes state actions.
        virtual void update(hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output);

            /// Process the user input - causes state transitions.
        virtual void change(hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output);

            /// Get the jump height
        hkReal getJumpHeight() const;

            /// Set the jump height
        void setJumpHeight( hkReal jumpHeight );

    protected:

        hkReal m_jumpHeight;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
