// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Utilities/CharacterControl/StateMachine/hkpCharacterState.h>

class HK_EXPORT_PHYSICS_2012 hkpCharacterStateInAir : public hkpCharacterState
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        hkpCharacterStateInAir();

            /// Return the state type
        virtual hkpCharacterStateType getType() const;

            /// Process the user input - causes state actions.
        virtual void update(hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output);

            /// Process the user input - causes state transitions.
        virtual void change(hkpCharacterContext& context, const hkpCharacterInput& input, hkpCharacterOutput& output);

            /// gets the gain for this feedback controller
        hkReal getGain() const;

            /// Sets the gain for this feedback controller
        void setGain(hkReal newGain);

            /// gets the air speed
        hkReal getSpeed() const;

            /// Sets the air speed
        void setSpeed(hkReal newGain);

            /// Gets the maximal linear acceleration for this state
        hkReal getMaxLinearAcceleration() const;

            /// Set the maximal linear acceleration for this state
        void setMaxLinearAcceleration(hkReal newMaxAcceleration);


    protected:

        hkReal  m_gain;

        hkReal  m_airSpeed;

        hkReal  m_maxLinearAcceleration;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
