// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Dynamics/Entity/hkpEntity.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>

class hkpCharacterRigidBody;
class hkpCapsuleShape;
class hkpWorldPostSimulationListener;
class hkpSimpleConstraintContactMgr;

/// A listener which modifies the interaction of a hkpCharacterRigidBody's rigid body for
/// maxSlope, maxForce and welding.
class HK_EXPORT_PHYSICS_2012 hkpCharacterRigidBodyListener : public hkReferencedObject
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Destructor.
        virtual ~hkpCharacterRigidBodyListener() { }

    public:

            /// Called after every simulation step.
            /// Calls discardVerticalPoints and then processActualPoints.
        virtual void characterCallback( hkpWorld* world, hkpCharacterRigidBody* characterRB );

    public:

            /// Remove all additional vertical points we added in the last step.
        void discardVerticalPoints( hkpCharacterRigidBody* characterRB );

            /// Applies processActualPoints to each of the character's collision entries.
        void processActualPoints( hkpWorld* world, hkpCharacterRigidBody* characterRB );

            /// Process a collision entry for contact points for unwelding, maxSlope and maxForce.
            /// Calls unweldContactPoints, considerCollisionEntryForSlope and considerCollisionEntryForMassModification.
        virtual void processActualPoints( const hkpWorld* world, hkpCharacterRigidBody* characterRB, const hkpLinkedCollidable::CollisionEntry& entry, hkpSimpleConstraintContactMgr* mgr, hkArray<hkContactPointId>& contactPointIds );

    public:
            /// Within the specified range, reorient welded contact point normals.
        virtual void unweldContactPoints( hkpCharacterRigidBody* characterRB, const hkpLinkedCollidable::CollisionEntry& entry, hkpSimpleConstraintContactMgr* mgr, const hkArray<hkContactPointId>& contactPointIds );

            /// Traverse all the contact points in a collision entry, adding vertical planes as necessary.
        virtual void considerCollisionEntryForSlope( const hkpWorld* world, hkpCharacterRigidBody* characterRB, const hkpLinkedCollidable::CollisionEntry& entry, hkpSimpleConstraintContactMgr* mgr, hkArray<hkContactPointId>& contactPointIds );

            /// For each collision entry, limit the responses involved based on the character's m_maxForce value.
        virtual void considerCollisionEntryForMassModification( const hkpWorld* world, hkpCharacterRigidBody* characterRB, const hkpLinkedCollidable::CollisionEntry& entry, hkpSimpleConstraintContactMgr* mgr, const hkArray<hkContactPointId>& contactPointIds );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
