// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Query/Collector/PointCollector/hkpAllCdPointCollector.h>

class hkpCharacterProxy;
class hkpShapePhantom;
struct hkpLinearCastInput;

/// Contains some useful methods for integrating the hkpCharacterProxy on CPU.
class HK_EXPORT_PHYSICS_2012 hkpCpuCharacterProxyUtil
{
    public:
            /// Used when integrating the character single-threaded.
        static inline void linearCastSetPositionAndCast( hkpShapePhantom* phantom
            , const hkpLinearCastInput& input
            , hkpAllCdPointCollector& castCollector
            , hkpAllCdPointCollector* startCollector
            , const hkVector4& position
            );

            /// Used when multithreading the character for the first linear cast.
            /// This is an optimization: we can use the phantom's set of overlapping collidables
            /// to skip the broadphase query required by a world cast.
        static void HK_CALL linearCastPhantomCast( const hkpCharacterProxy* character
            , const hkpLinearCastInput& input
            , hkpAllCdPointCollector& castCollector
            , hkpAllCdPointCollector* startCollector
            );

            /// Used when multithreading the character for the second and subsequent linear casts.
        static inline void linearCastWorldCast( const hkpShapePhantom* phantom
            , const hkpLinearCastInput& input
            , hkpCollidable* collidable
            , hkpAllCdPointCollector& castCollector
            , hkpAllCdPointCollector* startCollector
            );
};

#include<Physics2012/Utilities/CharacterControl/CharacterProxy/Multithreaded/Cpu/hkpCpuCharacterProxyUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
