// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Query/Collector/PointCollector/hkpAllCdPointCollector.h>

/// When multithreading, it wouldn't be thread safe to cast the original collidable around the
/// world, so we use a separate collidable. This collector is used to ignore collisions between
/// the new collidable and the original collidable.
class HK_EXPORT_PHYSICS_2012 hkpCpuCharacterProxyCollector : public hkpAllCdPointCollector
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CHARACTER, hkpCpuCharacterProxyCollector );

            // Implements the hkpCdPointCollector interface.
        virtual void addCdPoint( const hkpCdPoint& event );

            /// The collector is reused for each command, so its character's collidable is updated
            /// using this method.
        inline void setCharactersCollidable( const hkpCollidable* collidable ) { m_charactersCollidable = collidable; }

    protected:
            /// The original collidable of the character.
        const hkpCollidable* m_charactersCollidable;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
