// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Phantom/hkpAabbPhantom.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>

#include <Physics2012/Utilities/Actions/Wind/hkpWind.h>

/// Given a phantom and a wind, will apply the wind to those rigid bodies intersecting the
/// phantom.
class HK_EXPORT_PHYSICS_2012 hkpWindRegion : public hkReferencedObject, public hkpWorldPostSimulationListener
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Constructor.
        hkpWindRegion( hkpAabbPhantom* phantom, const hkpWind* wind, hkReal resistanceFactor, hkReal obbFactor = 0.0f );
            /// Destructor.
        virtual ~hkpWindRegion();

            /// Listener callback.
        virtual void postSimulationCallback( hkpWorld* world );

    private:
            /// The phantom which represents the region.
        hkpAabbPhantom* m_phantom;
            /// The wind that this phantom should apply to intersecting bodies.
        const hkpWind *const m_wind;
            ///
        hkReal m_resistanceFactor;
            ///
        hkReal m_obbFactor;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
