// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Utilities/Actions/Wind/hkpWindAction.h>

hkpWindAction::hkpWindAction( hkpRigidBody* body, const hkpWind* wind, hkReal resistanceFactor, hkReal obbFactor )
:   hkpUnaryAction( body ),
    m_wind( wind ),
    m_resistanceFactor( resistanceFactor ),
    m_obbFactor( obbFactor )
{
    m_wind->addReference();
}

hkpWindAction::~hkpWindAction()
{
    m_wind->removeReference();
}

hkpAction* hkpWindAction::clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const
{
    HK_ASSERT(0xf578efca, newEntities.getSize() == 1, "Wrong clone parameters given to an aerodynamics action (needs 1 body).");
    if (newEntities.getSize() != 1) return HK_NULL;

    HK_ASSERT(0x277857f0, newPhantoms.getSize() == 0, "Wrong clone parameters given to an aerodynamics action (needs 0 phantoms).");
    // should have no phantoms.
    if (newPhantoms.getSize() != 0) return HK_NULL;

    hkpWindAction* aa = new hkpWindAction( (hkpRigidBody*)newEntities[0], m_wind, m_resistanceFactor, m_obbFactor );
    aa->m_userData = m_userData;

    return aa;
}

void hkpWindAction::applyAction( const hkStepInfo& stepInfo )
{
    hkpRigidBody* rb = getRigidBody();

    m_wind->applyWindAndResistance( rb, stepInfo.m_deltaTime, m_resistanceFactor, m_obbFactor );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
