// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Action/hkpUnaryAction.h>

class hkpRigidBody;


    /// This action will try to orientate a rigid body so that it's local up
    /// matches a specified world up vector.
    /// It is similar in functionality to an hkpAngularDashpotAction however,
    /// it will only apply rotational impulses around the specified axis.
class HK_EXPORT_PHYSICS_2012 hkpReorientAction : public hkpUnaryAction
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        hkpReorientAction();

            /// Creates an angular dashpot with the specified construction info.
            /// Assumes that the rotation axis is perpendicular to the up axis.
        hkpReorientAction( hkpRigidBody* body,
            const hkVector4& rotationAxis,
            const hkVector4& upAxis,
            hkReal strength = 1.0f,
            hkReal damping = 0.1f );

            /// Applies angular impulses to a rigid body to try and lock
            /// orientation about a specified axis.
        void applyAction( const hkStepInfo& stepInfo );

            /// hkpAction clone interface.
        virtual hkpAction* clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const;

    public:

        hkVector4 m_rotationAxis;
        hkVector4 m_upAxis;
        hkReal m_strength;
        hkReal m_damping;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
