// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkpMotorAction::hkpMotorAction()
: hkpUnaryAction(HK_NULL),
  m_spinRate(0.0f),
  m_gain(2.0f),
  m_active(true)
{
    m_axis.setZero();
}

inline hkReal hkpMotorAction::getSpinRate() const
{
    return m_spinRate;
}

inline void hkpMotorAction::setSpinRate(hkReal new_rate)
{
    m_spinRate = new_rate;
}

inline hkReal hkpMotorAction::getGain() const
{
    return m_gain;
}

inline void hkpMotorAction::setGain(hkReal new_gain)
{
    m_gain = new_gain;
}

inline const hkVector4& hkpMotorAction::getAxis() const
{
    return m_axis;
}

inline void hkpMotorAction::setAxis(const hkVector4& axis)
{
    m_axis = axis;
}

inline hkBool hkpMotorAction::isActive() const
{
    return m_active;
}

inline void hkpMotorAction::setActivation(hkBool b)
{
    m_active = b;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
