// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Physics2012/Utilities/Actions/Dashpot/hkpDashpotAction.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

hkpDashpotAction::hkpDashpotAction(hkpRigidBody* entityA, hkpRigidBody* entityB , hkUlong userData )
: hkpBinaryAction( entityA, entityB, userData ),
  m_strength(0.1f),
  m_damping(0.01f)
{
    m_point[0].setZero();
    m_point[1].setZero();
}

const hkVector4 & hkpDashpotAction::getImpulse()
{
    return m_impulse;
}


void hkpDashpotAction::applyAction(const hkStepInfo& stepInfo)
{
    HK_TIMER_BEGIN("Dashpot", HK_NULL);

    const hkReal dtscale = 151; // to keep constants sensible around 1
    hkReal dt = dtscale * (stepInfo.m_deltaTime);

    hkpRigidBody* ra = static_cast<hkpRigidBody*>( m_entityA );
    hkpRigidBody* rb = static_cast<hkpRigidBody*>( m_entityB );
    HK_ASSERT(0xf568efca, ra && rb, "Bodies not set in dashpot.");

    hkVector4 pa;

    pa.setTransformedPos(ra->getTransform(),m_point[0]);
    const hkVector4& va = ra->getLinearVelocity();

    hkVector4 pb;

    pb.setTransformedPos(rb->getTransform(),m_point[1]);
    const hkVector4& vb = rb->getLinearVelocity();

    //m_impulse = (dt * m_strength) * ( pa - pb ) +  * ( va - vb ) Below
    {
      hkVector4 pab;
      hkVector4 vab;

      pab.setSub(pa,pb);
      vab.setSub(va,vb);

      m_impulse.setMul(hkSimdReal::fromFloat(dt * m_strength), pab);
      vab.mul(hkSimdReal::fromFloat(dt * m_damping));
      m_impulse.add(vab);
    }

    /*
    DISPLAY2(showPoint, pa, 0xffffffff );
    DISPLAY2(showPoint, pb, 0xffffffff );
    DISPLAY3(showLine,  pb, pb+m_impulse,   0xffff0000 );
    */

    {
        hkVector4 negImpulse;
        negImpulse.setNeg<4>(m_impulse);
        ra->applyPointImpulse(negImpulse, pa);
    }

    {
        rb->applyPointImpulse( m_impulse, pb);
    }

    HK_TIMER_END();
}

// hkpAction clone interface.
hkpAction* hkpDashpotAction::clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const
{
    HK_ASSERT(0xf568efca, newEntities.getSize() == 2, "Wrong clone parameters given to a spring action (needs 2 bodies).");
    // should have two entities as we are a binary action.
    if (newEntities.getSize() != 2) return HK_NULL;

    HK_ASSERT(0x736ad5a4, newPhantoms.getSize() == 0, "Wrong clone parameters given to a spring action (needs 0 phantoms).");
    // should have no phantoms.
    if (newPhantoms.getSize() != 0) return HK_NULL;

    hkpDashpotAction* sa = new hkpDashpotAction( (hkpRigidBody*)newEntities[0], (hkpRigidBody*)newEntities[1], m_userData );
    sa->m_point[0] = m_point[0];
    sa->m_point[1] = m_point[1];
    sa->m_strength = m_strength;
    sa->m_damping = m_damping;
    sa->m_impulse = m_impulse;

    return sa;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
