// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_PLATFORM_SPU)
    #include <Common/GeometryUtilities/Spu/hkSpuConfig.h>
    #include <Common/Base/Memory/PlatformUtils/Spu/SpuDmaCache/hkSpu4WayCache.h>
    extern class hkSpu4WayCache* g_SpuCollideUntypedCache;
#endif


HK_INLINE const hkArray<hkpStaticCompoundShape::Instance>& hkpStaticCompoundShape::getInstances() const
{
    return m_instances;
}

HK_INLINE hkInt8 hkpStaticCompoundShape::getNumBitsForChildShapeKey() const
{
    return m_numBitsForChildShapeKey;
}

HK_INLINE hkpShapeKey hkpStaticCompoundShape::composeShapeKey( int instanceId, hkpShapeKey childKey ) const
{
    HK_ASSERT(0x24fbe155, m_numBitsForChildShapeKey > 0, "Shape not baked yet!" );
    HK_ASSERT(0x2f7b7cd9, (childKey & m_childShapeKeyMask) == childKey, "Child shape key is too big!" );
    return ( instanceId << m_numBitsForChildShapeKey ) | childKey;
}

HK_INLINE void hkpStaticCompoundShape::decomposeShapeKey( hkpShapeKey keyIn, int& instanceIdOut, hkpShapeKey& childKeyOut ) const
{
    HK_ASSERT(0x24fbe155, m_numBitsForChildShapeKey > 0, "Shape not baked yet!" );
    instanceIdOut = keyIn >> m_numBitsForChildShapeKey;
    HK_ASSERT_NO_MSG(0x5cfbaf05, instanceIdOut >= 0 && instanceIdOut < m_instances.getSize() );
    childKeyOut = keyIn & m_childShapeKeyMask;
}


HK_INLINE const hkQsTransform& hkpStaticCompoundShape::Instance::getTransform() const
{
    return m_transform;
}

HK_INLINE const hkpShape* hkpStaticCompoundShape::Instance::getShape() const
{
    return m_shape;
}


HK_INLINE void hkpStaticCompoundShape::Instance::setFlags( hkUint32 flags )
{
    m_transform.m_translation.setInt24W( ( m_transform.m_translation.getInt24W() & ~FLAGS_ALL ) | flags );
}

HK_INLINE hkUint32 hkpStaticCompoundShape::Instance::getFlags() const
{
    return m_transform.m_translation.getInt24W() & FLAGS_ALL;
}


HK_INLINE void hkpStaticCompoundShape::Instance::setShapeSizeForSpu( hkUint32 size )
{
    const hkUint32 shapeSizeMask = ((1 << (hkUint32)NUM_BITS_FOR_SHAPE_SIZE) - 1) << NUM_BITS_FOR_FLAGS;
    hkUint32 bitfield = ( m_transform.m_translation.getInt24W() & ~shapeSizeMask );

    const hkUint32 storedShapeSize = size / 16;
    HK_ASSERT_NO_MSG(0x8b3e4bd, storedShapeSize <= ((1 << (hkUint32)NUM_BITS_FOR_SHAPE_SIZE) - 1) );

    bitfield |= storedShapeSize << NUM_BITS_FOR_FLAGS;
    m_transform.m_translation.setInt24W( bitfield );
}

HK_INLINE hkUint32 hkpStaticCompoundShape::Instance::getShapeSizeForSpu() const
{
    return ( (m_transform.m_translation.getInt24W() >> NUM_BITS_FOR_FLAGS) & ((1 << (hkUint32)NUM_BITS_FOR_SHAPE_SIZE) - 1) ) * 16;
}


HK_INLINE void hkpStaticCompoundShape::setInstanceFilterInfo( int instanceId, hkUint32 filterInfo )
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    m_instances[instanceId].m_filterInfo = filterInfo;
}

HK_INLINE hkUint32 hkpStaticCompoundShape::getInstanceFilterInfo( int instanceId ) const
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    return m_instances[instanceId].m_filterInfo;
}


HK_INLINE void hkpStaticCompoundShape::setInstanceFilterInfoMask( int instanceId, hkUint32 filterInfoMask )
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    m_instances[instanceId].m_childFilterInfoMask = filterInfoMask;
}

HK_INLINE hkUint32 hkpStaticCompoundShape::getInstanceFilterInfoMask( int instanceId ) const
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    return m_instances[instanceId].m_childFilterInfoMask;
}


HK_INLINE void hkpStaticCompoundShape::setInstanceUserData( int instanceId, hkUlong userData )
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    m_instances[instanceId].m_userData = userData;
}

HK_INLINE hkUlong hkpStaticCompoundShape::getInstanceUserData( int instanceId ) const
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    return m_instances[instanceId].m_userData;
}


HK_INLINE void hkpStaticCompoundShape::setInstanceExtraInfo( int instanceId, hkUint16 extraInfo )
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    const int maxSize = hkMath::max2( m_instanceExtraInfos.getSize(), instanceId + 1 );
    m_instanceExtraInfos.setSize( maxSize );
    m_instanceExtraInfos[instanceId] = extraInfo;
}


HK_INLINE hkUint16 hkpStaticCompoundShape::getInstanceExtraInfo( int instanceId ) const
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() && instanceId < m_instanceExtraInfos.getSize() );
#if defined(HK_PLATFORM_SPU)
    return *hkGetArrayElemUsingCacheHalfSize( m_instanceExtraInfos.begin(), instanceId, g_SpuCollideUntypedCache, HK_SPU_UNTYPED_CACHE_LINE_SIZE );
#else
    return m_instanceExtraInfos[instanceId];
#endif
}


HK_INLINE void hkpStaticCompoundShape::setInstanceEnabled( int instanceId, hkBool32 isEnabled )
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    Instance& instance = m_instances[instanceId];
    hkUint32 flags = instance.getFlags();
    flags = (isEnabled ? (flags & ~Instance::FLAG_IS_DISABLED) : (flags | Instance::FLAG_IS_DISABLED));
    instance.setFlags(flags);
}

HK_INLINE hkBool32 hkpStaticCompoundShape::isInstanceEnabled( int instanceId ) const
{
    HK_ASSERT_NO_MSG(0x17a29c, instanceId < m_instances.getSize() );
    return !( m_instances[instanceId].getFlags() & Instance::FLAG_IS_DISABLED );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
