// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent3/hkpAgent3.h>
#include <Physics2012/Collide/Shape/Convex/hkpConvexShape.h>

    // this is minimal timestep. This only affects collisions if
    // a point of an object
    // at time x                is outside the m_toiDistance
    // at time x+minTimeStep    is outside the m_toiDistance
    // but in between           its inside m_minSeparation
    //
    // This can only happen if you have very high angular velocities
    // Note: Ipion used a value of 1e-3f
class hkpGskCache;

struct hkp4dGskVertexCollidePointsInput
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkp4dGskVertexCollidePointsInput );

    const hkMotionState*    m_motionA;
    const hkMotionState*    m_motionB;

    hkVector4*          m_verticesA;
    int                 m_numVertices;
    int                 m_allocatedNumVertices;

    hkReal              m_radiusSum;
    hkReal              m_maxAccel;
    hkReal              m_invMaxAccel;

    hkVector4                       m_planeB;        // in B space
    hkVector4                       m_pointOnPlaneB; // in B space

    const hkStepInfo*       m_stepInfo;

    hkReal              m_worstCaseApproachingDelta;

    hkVector4                       m_linearTimInfo;
    hkVector4                       m_deltaAngles[2];

    hkReal              m_startRt;  // the relative time to start
};

struct hkp4dGskVertexCollidePointsOutput
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkp4dGskVertexCollidePointsOutput );

    hkReal m_Rtoi;
    hkVector4 m_collidingPoint;

    hkp4dGskVertexCollidePointsOutput(): m_Rtoi(1.0f){} //m_toi( hkTime(HK_REAL_MAX)){}
};

struct hkpProcessCollisionOutput;

struct hkp4dGskTolerances
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CDINFO, hkp4dGskTolerances );

    hkReal m_toiSeparation;
    hkReal m_minSeparation;

    hkReal m_minSafeDeltaRt;    // the minimum timestep scaled to [0..1]
    hkReal m_minToiDeltaTime;       // = 1/maxToiFrequency

    hkReal m_toiAccuracy;
};


extern "C"
{
    void hk4dGskCollidePointsWithPlane( const hkp4dGskVertexCollidePointsInput& input, const hkp4dGskTolerances& tol, hkp4dGskVertexCollidePointsOutput& out );

        /// Find the time of impact.
        /// Rules:
        ///     - If we detect a TOI, we return the time when the distance is exactly toiSeparation
        ///     - We will not miss a TOI if the distance goes below minSeparation
        ///     - That means minSeparation < toiSeparation < 0.0f
    void hk4dGskCollideCalcToi( const hkpAgent3ProcessInput& in3, hkSimdRealParameter allowedPenetrationDepth, hkSimdRealParameter minSeparation, hkSimdRealParameter toiSeparation, hkpGskCache& gskCache, hkVector4& separatingNormal, hkpProcessCollisionOutput& output );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
