// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>

///
/// The output from the hkpConvexPieceMeshBuilder is constructed
/// by converting the arrays representing the convex pieces into a
/// data stream, which allows faster access and has a smaller storage
/// capacity.
///
/// This structure can be used as input to a hkpConvexPieceMeshShape.
///
class hkpConvexPieceStreamData : public hkReferencedObject
{
    public:
        HK_DECLARE_REFLECTION();
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CDINFO);

        /// A bitstream representing the triangles in each
        /// convex piece.
        hkArray< hkUint32 > m_convexPieceStream;

        /// The offsets in the bitstream to the start of each convex piece.
        hkArray<hkUint32> m_convexPieceOffsets;

        /// An array of convex pieces that are only one triangle.
        hkArray<hkpShapeKey> m_convexPieceSingleTriangles;

        hkpConvexPieceStreamData() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
