// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if 0
R\
"exclude1(";
R"exclude2()exclude1";
#endif

#pragma once

#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define UNPACK_OPT_PARAM(...) __VA_ARGS__
#if defined(HK_FILTER_REFLECT_OPT)
#   undef HK_FILTER_REFLECT_OPT
#endif
#if defined(HK_EXCLUDE_FROM_DATA_REFLECTION)
#   undef HK_EXCLUDE_FROM_DATA_REFLECTION
#endif
#if defined(HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION)
#   undef HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION
#endif
#if defined(HK_REFLECT_TYPE_DATA_ONLY)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_ONLY_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x)
#elif defined(HK_REFLECT_TYPE_CONSTRUCTABLE)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_CONSTRUCTIBLE_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#else
#   define HK_FILTER_REFLECT_OPT(x) (x)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x) UNPACK_OPT_PARAM x
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#endif

#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>


struct hkpWorldCinfo::_Auto
{    
    struct m_gravity { static const hkReflect::Detail::TypeData typeData;};
    struct m_broadPhaseQuerySize { static const hkReflect::Detail::TypeData typeData;};
    struct m_contactRestingVelocity { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_broadPhaseType(const void* valuePtr) { const decltype(hkpWorldCinfo::m_broadPhaseType)& fieldValue = *reinterpret_cast<const decltype(hkpWorldCinfo::m_broadPhaseType)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_broadPhaseType { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_broadPhaseBorderBehaviour(const void* valuePtr) { const decltype(hkpWorldCinfo::m_broadPhaseBorderBehaviour)& fieldValue = *reinterpret_cast<const decltype(hkpWorldCinfo::m_broadPhaseBorderBehaviour)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_broadPhaseBorderBehaviour { static const hkReflect::Detail::TypeData typeData;};
    struct m_mtPostponeAndSortBroadPhaseBorderCallbacks { static const hkReflect::Detail::TypeData typeData;};
    struct m_broadPhaseWorldAabb { static const hkReflect::Detail::TypeData typeData;};
    struct m_collisionTolerance { static const hkReflect::Detail::TypeData typeData;};
    struct m_collisionFilter { static const hkReflect::Detail::TypeData typeData;};
    struct m_convexListFilter { static const hkReflect::Detail::TypeData typeData;};
    struct m_expectedMaxLinearVelocity { static const hkReflect::Detail::TypeData typeData;};
    struct m_sizeOfToiEventQueue { static const hkReflect::Detail::TypeData typeData;};
    struct m_expectedMinPsiDeltaTime { static const hkReflect::Detail::TypeData typeData;};
    struct m_memoryWatchDog { static const hkReflect::Detail::TypeData typeData;};
    struct m_broadPhaseNumMarkers { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_contactPointGeneration(const void* valuePtr) { const decltype(hkpWorldCinfo::m_contactPointGeneration)& fieldValue = *reinterpret_cast<const decltype(hkpWorldCinfo::m_contactPointGeneration)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_contactPointGeneration { static const hkReflect::Detail::TypeData typeData;};
    struct m_allowToSkipConfirmedCallbacks { static const hkReflect::Detail::TypeData typeData;};
    struct m_solverTau { static const hkReflect::Detail::TypeData typeData;};
    struct m_solverDamp { static const hkReflect::Detail::TypeData typeData;};
    struct m_solverIterations { static const hkReflect::Detail::TypeData typeData;};
    struct m_solverMicrosteps { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxConstraintViolation { static const hkReflect::Detail::TypeData typeData;};
    struct m_forceCoherentConstraintOrderingInSolver { static const hkReflect::Detail::TypeData typeData;};
    struct m_snapCollisionToConvexEdgeThreshold { static const hkReflect::Detail::TypeData typeData;};
    struct m_snapCollisionToConcaveEdgeThreshold { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableToiWeldRejection { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableDeprecatedWelding { static const hkReflect::Detail::TypeData typeData;};
    struct m_iterativeLinearCastEarlyOutDistance { static const hkReflect::Detail::TypeData typeData;};
    struct m_iterativeLinearCastMaxIterations { static const hkReflect::Detail::TypeData typeData;};
    struct m_deactivationNumInactiveFramesSelectFlag0 { static const hkReflect::Detail::TypeData typeData;};
    struct m_deactivationNumInactiveFramesSelectFlag1 { static const hkReflect::Detail::TypeData typeData;};
    struct m_deactivationIntegrateCounter { static const hkReflect::Detail::TypeData typeData;};
    struct m_shouldActivateOnRigidBodyTransformChange { static const hkReflect::Detail::TypeData typeData;};
    struct m_deactivationReferenceDistance { static const hkReflect::Detail::TypeData typeData;};
    struct m_toiCollisionResponseRotateNormal { static const hkReflect::Detail::TypeData typeData;};
    struct m_useCompoundSpuElf { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxSectorsPerMidphaseCollideTask { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxSectorsPerNarrowphaseCollideTask { static const hkReflect::Detail::TypeData typeData;};
    struct m_processToisMultithreaded { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxEntriesPerToiMidphaseCollideTask { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxEntriesPerToiNarrowphaseCollideTask { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxNumToiCollisionPairsSinglethreaded { static const hkReflect::Detail::TypeData typeData;};
    struct m_numToisTillAllowedPenetrationSimplifiedToi { static const hkReflect::Detail::TypeData typeData;};
    struct m_numToisTillAllowedPenetrationToi { static const hkReflect::Detail::TypeData typeData;};
    struct m_numToisTillAllowedPenetrationToiHigher { static const hkReflect::Detail::TypeData typeData;};
    struct m_numToisTillAllowedPenetrationToiForced { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableDeactivation { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_simulationType(const void* valuePtr) { const decltype(hkpWorldCinfo::m_simulationType)& fieldValue = *reinterpret_cast<const decltype(hkpWorldCinfo::m_simulationType)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_simulationType { static const hkReflect::Detail::TypeData typeData;};
    struct m_enableSimulationIslands { static const hkReflect::Detail::TypeData typeData;};
    struct m_minDesiredIslandSize { static const hkReflect::Detail::TypeData typeData;};
    struct m_processActionsInSingleThread { static const hkReflect::Detail::TypeData typeData;};
    struct m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob { static const hkReflect::Detail::TypeData typeData;};
    struct m_frameMarkerPsiSnap { static const hkReflect::Detail::TypeData typeData;};
    struct m_fireCollisionCallbacks { static const hkReflect::Detail::TypeData typeData;};
    struct Decls { static const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,54> decls;};
    #if !defined(HK_REFLECT_TYPE_DATA_ONLY) || defined(HK_REFLECT_TYPE_CONSTRUCTABLE)
    static void afterReflectNew(void* thisPtr)
    {
        reinterpret_cast<hkpWorldCinfo*>(thisPtr)->afterReflectNew();
    }
    #endif
    static inline bool isValid(const hkpWorldCinfo& value) { return isValid_m_broadPhaseType(&value.m_broadPhaseType) && isValid_m_broadPhaseBorderBehaviour(&value.m_broadPhaseBorderBehaviour) && isValid_m_contactPointGeneration(&value.m_contactPointGeneration) && isValid_m_simulationType(&value.m_simulationType); }
    static inline bool isValidPtr(const void* valuePtr) { return isValid(*reinterpret_cast<const hkpWorldCinfo*>(valuePtr)); }    
};


struct hkpWorldCinfo_SolverType_Auto
{    
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_INVALID;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_2ITERS_SOFT;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_2ITERS_MEDIUM;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_2ITERS_HARD;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_4ITERS_SOFT;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_4ITERS_MEDIUM;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_4ITERS_HARD;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_8ITERS_SOFT;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_8ITERS_MEDIUM;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_8ITERS_HARD;
    static const hkpWorldCinfo::SolverType hkPresets_SOLVER_TYPE_MAX_ID;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> SolverType_attributes;    
};


struct hkpWorldCinfo_SimulationType_Auto
{    
    static const hkpWorldCinfo::SimulationType hkPresets_SIMULATION_TYPE_INVALID;
    static const hkpWorldCinfo::SimulationType hkPresets_SIMULATION_TYPE_DISCRETE;
    static const hkpWorldCinfo::SimulationType hkPresets_SIMULATION_TYPE_CONTINUOUS;
    static const hkpWorldCinfo::SimulationType hkPresets_SIMULATION_TYPE_MULTITHREADED;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> SimulationType_attributes;    
};


struct hkpWorldCinfo_ContactPointGeneration_Auto
{    
    static const hkpWorldCinfo::ContactPointGeneration hkPresets_CONTACT_POINT_ACCEPT_ALWAYS;
    static const hkpWorldCinfo::ContactPointGeneration hkPresets_CONTACT_POINT_REJECT_DUBIOUS;
    static const hkpWorldCinfo::ContactPointGeneration hkPresets_CONTACT_POINT_REJECT_MANY;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> ContactPointGeneration_attributes;    
};


struct hkpWorldCinfo_BroadPhaseType_Auto
{    
    static const hkpWorldCinfo::BroadPhaseType hkPresets_BROADPHASE_TYPE_SAP;
    static const hkpWorldCinfo::BroadPhaseType hkPresets_BROADPHASE_TYPE_TREE;
    static const hkpWorldCinfo::BroadPhaseType hkPresets_BROADPHASE_TYPE_HYBRID;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> BroadPhaseType_attributes;    
};


struct hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto
{    
    static const hkpWorldCinfo::BroadPhaseBorderBehaviour hkPresets_BROADPHASE_BORDER_ASSERT;
    static const hkpWorldCinfo::BroadPhaseBorderBehaviour hkPresets_BROADPHASE_BORDER_FIX_ENTITY;
    static const hkpWorldCinfo::BroadPhaseBorderBehaviour hkPresets_BROADPHASE_BORDER_REMOVE_ENTITY;
    static const hkpWorldCinfo::BroadPhaseBorderBehaviour hkPresets_BROADPHASE_BORDER_DO_NOTHING;
    static const char* const hkPresets_names[];
    static const void* const hkPresets_value[];
    static const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> BroadPhaseBorderBehaviour_attributes;    
};




#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// CXXRecord: hkpWorldCinfo
//
struct hkpWorldCinfo_m_gravity_Auto
{
    static const hkReflect::Detail::AggregateOf< hkVector4 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkVector4 >::Type hkpWorldCinfo_m_gravity_Auto::defaultVal = { 0, -9.8f, 0 };


struct hkpWorldCinfo_m_broadPhaseQuerySize_Auto
{
    static const hkReflect::Detail::AggregateOf< hkInt32 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkInt32 >::Type hkpWorldCinfo_m_broadPhaseQuerySize_Auto::defaultVal = 1024;


struct hkpWorldCinfo_m_mtPostponeAndSortBroadPhaseBorderCallbacks_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_mtPostponeAndSortBroadPhaseBorderCallbacks_Auto::defaultVal = false;


struct hkpWorldCinfo_m_collisionTolerance_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_collisionTolerance_Auto::defaultVal = .1;


struct hkpWorldCinfo_m_expectedMaxLinearVelocity_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_expectedMaxLinearVelocity_Auto::defaultVal = 200;


struct hkpWorldCinfo_m_sizeOfToiEventQueue_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_sizeOfToiEventQueue_Auto::defaultVal = 250;


struct hkpWorldCinfo_m_expectedMinPsiDeltaTime_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_expectedMinPsiDeltaTime_Auto::defaultVal = 1.0f/30.0f;


struct hkpWorldCinfo_m_allowToSkipConfirmedCallbacks_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_allowToSkipConfirmedCallbacks_Auto::defaultVal = false;


struct hkpWorldCinfo_m_solverDamp_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_solverDamp_Auto::defaultVal = .6;


struct hkpWorldCinfo_m_solverIterations_Auto
{
    static const hkReflect::Detail::AggregateOf< hkInt32 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkInt32 >::Type hkpWorldCinfo_m_solverIterations_Auto::defaultVal = 4;


struct hkpWorldCinfo_m_solverMicrosteps_Auto
{
    static const hkReflect::Detail::AggregateOf< hkInt32 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkInt32 >::Type hkpWorldCinfo_m_solverMicrosteps_Auto::defaultVal = 1;


struct hkpWorldCinfo_m_maxConstraintViolation_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_maxConstraintViolation_Auto::defaultVal = 1.8446726e+019f;


struct hkpWorldCinfo_m_forceCoherentConstraintOrderingInSolver_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_forceCoherentConstraintOrderingInSolver_Auto::defaultVal = false;


struct hkpWorldCinfo_m_snapCollisionToConvexEdgeThreshold_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_snapCollisionToConvexEdgeThreshold_Auto::defaultVal = .524;


struct hkpWorldCinfo_m_snapCollisionToConcaveEdgeThreshold_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_snapCollisionToConcaveEdgeThreshold_Auto::defaultVal = 0.698;


struct hkpWorldCinfo_m_enableToiWeldRejection_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_enableToiWeldRejection_Auto::defaultVal = false;


struct hkpWorldCinfo_m_enableDeprecatedWelding_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_enableDeprecatedWelding_Auto::defaultVal = false;


struct hkpWorldCinfo_m_iterativeLinearCastEarlyOutDistance_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_iterativeLinearCastEarlyOutDistance_Auto::defaultVal = .01;


struct hkpWorldCinfo_m_iterativeLinearCastMaxIterations_Auto
{
    static const hkReflect::Detail::AggregateOf< hkInt32 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkInt32 >::Type hkpWorldCinfo_m_iterativeLinearCastMaxIterations_Auto::defaultVal = 20;


struct hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag0_Auto
{
    static const hkReflect::Detail::AggregateOf< hkUint8 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkUint8 >::Type hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag0_Auto::defaultVal = 0;


struct hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag1_Auto
{
    static const hkReflect::Detail::AggregateOf< hkUint8 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkUint8 >::Type hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag1_Auto::defaultVal = 0;


struct hkpWorldCinfo_m_deactivationIntegrateCounter_Auto
{
    static const hkReflect::Detail::AggregateOf< hkUint8 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkUint8 >::Type hkpWorldCinfo_m_deactivationIntegrateCounter_Auto::defaultVal = 0;


struct hkpWorldCinfo_m_shouldActivateOnRigidBodyTransformChange_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_shouldActivateOnRigidBodyTransformChange_Auto::defaultVal = true;


struct hkpWorldCinfo_m_deactivationReferenceDistance_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_deactivationReferenceDistance_Auto::defaultVal = 0.02;


struct hkpWorldCinfo_m_toiCollisionResponseRotateNormal_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_toiCollisionResponseRotateNormal_Auto::defaultVal = 0.2;


struct hkpWorldCinfo_m_useCompoundSpuElf_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_useCompoundSpuElf_Auto::defaultVal = false;


struct hkpWorldCinfo_m_maxSectorsPerMidphaseCollideTask_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_maxSectorsPerMidphaseCollideTask_Auto::defaultVal = 2;


struct hkpWorldCinfo_m_maxSectorsPerNarrowphaseCollideTask_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_maxSectorsPerNarrowphaseCollideTask_Auto::defaultVal = 4;


struct hkpWorldCinfo_m_processToisMultithreaded_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_processToisMultithreaded_Auto::defaultVal = true;


struct hkpWorldCinfo_m_maxEntriesPerToiMidphaseCollideTask_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_maxEntriesPerToiMidphaseCollideTask_Auto::defaultVal = -1;


struct hkpWorldCinfo_m_maxEntriesPerToiNarrowphaseCollideTask_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_maxEntriesPerToiNarrowphaseCollideTask_Auto::defaultVal = -1;


struct hkpWorldCinfo_m_maxNumToiCollisionPairsSinglethreaded_Auto
{
    static const hkReflect::Detail::AggregateOf< int >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< int >::Type hkpWorldCinfo_m_maxNumToiCollisionPairsSinglethreaded_Auto::defaultVal = 0;


struct hkpWorldCinfo_m_numToisTillAllowedPenetrationSimplifiedToi_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_numToisTillAllowedPenetrationSimplifiedToi_Auto::defaultVal = 3.0;


struct hkpWorldCinfo_m_numToisTillAllowedPenetrationToi_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_numToisTillAllowedPenetrationToi_Auto::defaultVal = 3.0;


struct hkpWorldCinfo_m_numToisTillAllowedPenetrationToiHigher_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_numToisTillAllowedPenetrationToiHigher_Auto::defaultVal = 4.0;


struct hkpWorldCinfo_m_numToisTillAllowedPenetrationToiForced_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_numToisTillAllowedPenetrationToiForced_Auto::defaultVal = 20.0;


struct hkpWorldCinfo_m_enableDeactivation_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_enableDeactivation_Auto::defaultVal = true;


struct hkpWorldCinfo_m_enableSimulationIslands_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_enableSimulationIslands_Auto::defaultVal = true;


struct hkpWorldCinfo_m_minDesiredIslandSize_Auto
{
    static const hkReflect::Detail::AggregateOf< hkUint32 >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkUint32 >::Type hkpWorldCinfo_m_minDesiredIslandSize_Auto::defaultVal = 64;


struct hkpWorldCinfo_m_processActionsInSingleThread_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_processActionsInSingleThread_Auto::defaultVal = true;


struct hkpWorldCinfo_m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob_Auto::defaultVal = false;


struct hkpWorldCinfo_m_frameMarkerPsiSnap_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpWorldCinfo_m_frameMarkerPsiSnap_Auto::defaultVal = .0001;


struct hkpWorldCinfo_m_fireCollisionCallbacks_Auto
{
    static const hkReflect::Detail::AggregateOf< hkBool >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkBool >::Type hkpWorldCinfo_m_fireCollisionCallbacks_Auto::defaultVal = false;



hkReflect::Detail::AddrAndType hkpWorldCinfo::getExactType() const
{
    return hkReflect::Detail::AddrAndType(this, HK_REFLECT_GET_TYPE( hkpWorldCinfo ));
}
hkReflect::Detail::TypeRegNode hkpWorldCinfo_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo >::Holder::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::NAME | hkReflect::Opt::VERSION | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::DESTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::DECLS | hkReflect::Opt::AFTER_REFLECT_NEW | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReferencedObject ),//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfRecord::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VERSION, 18),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::ExplicitWrapper< hkReflect::Opt::DEF_CONSTRUCTOR, hkpWorldCinfo >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Implicit< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DESTRUCTOR, &hkReflect::Detail::ExplicitWrapper< hkReflect::Opt::DESTRUCTOR, hkpWorldCinfo >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Implicit< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo),HK_ALIGN_OF(hkpWorldCinfo),0)),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECLS, reinterpret_cast<const hkReflect::Detail::DeclsArray*>(&hkpWorldCinfo::_Auto::Decls::decls)),    
    HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::AFTER_REFLECT_NEW, &hkpWorldCinfo::_Auto::afterReflectNew),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpWorldCinfo::_Auto::isValidPtr),))    
};
const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_gravity::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkVector4_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_gravity_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "gravity"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_gravity, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_broadPhaseQuerySize::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_broadPhaseQuerySize_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "broadPhaseQuerySize"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_broadPhaseQuerySize, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_contactRestingVelocity::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "contactRestingVelocity"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_contactRestingVelocity, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_broadPhaseType::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hkpWorldCinfo::BroadPhaseType, hkReflect::Typedef::hkInt8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "broadPhaseType"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_broadPhaseType, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpWorldCinfo::_Auto::isValid_m_broadPhaseType),))
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_broadPhaseBorderBehaviour::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hkpWorldCinfo::BroadPhaseBorderBehaviour, hkReflect::Typedef::hkInt8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "broadPhaseBorderBehaviour"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_broadPhaseBorderBehaviour, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpWorldCinfo::_Auto::isValid_m_broadPhaseBorderBehaviour),))
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_mtPostponeAndSortBroadPhaseBorderCallbacks::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_mtPostponeAndSortBroadPhaseBorderCallbacks_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "mtPostponeAndSortBroadPhaseBorderCallbacks"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_mtPostponeAndSortBroadPhaseBorderCallbacks, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_broadPhaseWorldAabb::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkAabb ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "broadPhaseWorldAabb"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_broadPhaseWorldAabb, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_collisionTolerance::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_collisionTolerance_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "collisionTolerance"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_collisionTolerance, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_collisionFilter::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkRefPtr< hkpCollisionFilter > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "collisionFilter"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_collisionFilter, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_convexListFilter::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkRefPtr< hkpConvexListFilter > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "convexListFilter"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_convexListFilter, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_expectedMaxLinearVelocity::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_expectedMaxLinearVelocity_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "expectedMaxLinearVelocity"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_expectedMaxLinearVelocity, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_sizeOfToiEventQueue::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_sizeOfToiEventQueue_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "sizeOfToiEventQueue"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_sizeOfToiEventQueue, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_expectedMinPsiDeltaTime::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_expectedMinPsiDeltaTime_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "expectedMinPsiDeltaTime"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_expectedMinPsiDeltaTime, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_memoryWatchDog::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkRefPtr< hkWorldMemoryAvailableWatchDog > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "memoryWatchDog"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_memoryWatchDog, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_broadPhaseNumMarkers::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "broadPhaseNumMarkers"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_broadPhaseNumMarkers, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_contactPointGeneration::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hkpWorldCinfo::ContactPointGeneration, hkReflect::Typedef::hkInt8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "contactPointGeneration"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_contactPointGeneration, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpWorldCinfo::_Auto::isValid_m_contactPointGeneration),))
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_allowToSkipConfirmedCallbacks::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_allowToSkipConfirmedCallbacks_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "allowToSkipConfirmedCallbacks"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_allowToSkipConfirmedCallbacks, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_solverTau::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "solverTau"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_solverTau, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_solverDamp::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_solverDamp_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "solverDamp"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_solverDamp, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_solverIterations::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_solverIterations_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "solverIterations"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_solverIterations, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_solverMicrosteps::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_solverMicrosteps_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "solverMicrosteps"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_solverMicrosteps, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxConstraintViolation::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxConstraintViolation_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxConstraintViolation"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxConstraintViolation, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_forceCoherentConstraintOrderingInSolver::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_forceCoherentConstraintOrderingInSolver_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "forceCoherentConstraintOrderingInSolver"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_forceCoherentConstraintOrderingInSolver, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_snapCollisionToConvexEdgeThreshold::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_snapCollisionToConvexEdgeThreshold_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "snapCollisionToConvexEdgeThreshold"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_snapCollisionToConvexEdgeThreshold, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_snapCollisionToConcaveEdgeThreshold::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_snapCollisionToConcaveEdgeThreshold_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "snapCollisionToConcaveEdgeThreshold"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_snapCollisionToConcaveEdgeThreshold, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_enableToiWeldRejection::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_enableToiWeldRejection_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableToiWeldRejection"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableToiWeldRejection, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_enableDeprecatedWelding::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_enableDeprecatedWelding_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableDeprecatedWelding"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableDeprecatedWelding, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_iterativeLinearCastEarlyOutDistance::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_iterativeLinearCastEarlyOutDistance_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "iterativeLinearCastEarlyOutDistance"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_iterativeLinearCastEarlyOutDistance, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_iterativeLinearCastMaxIterations::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_iterativeLinearCastMaxIterations_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "iterativeLinearCastMaxIterations"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_iterativeLinearCastMaxIterations, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_deactivationNumInactiveFramesSelectFlag0::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkUint8_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag0_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "deactivationNumInactiveFramesSelectFlag0"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_deactivationNumInactiveFramesSelectFlag0, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_deactivationNumInactiveFramesSelectFlag1::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkUint8_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_deactivationNumInactiveFramesSelectFlag1_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "deactivationNumInactiveFramesSelectFlag1"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_deactivationNumInactiveFramesSelectFlag1, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_deactivationIntegrateCounter::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkUint8_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_deactivationIntegrateCounter_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "deactivationIntegrateCounter"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_deactivationIntegrateCounter, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_shouldActivateOnRigidBodyTransformChange::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_shouldActivateOnRigidBodyTransformChange_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "shouldActivateOnRigidBodyTransformChange"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_shouldActivateOnRigidBodyTransformChange, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_deactivationReferenceDistance::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_deactivationReferenceDistance_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "deactivationReferenceDistance"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_deactivationReferenceDistance, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_toiCollisionResponseRotateNormal::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_toiCollisionResponseRotateNormal_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "toiCollisionResponseRotateNormal"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_toiCollisionResponseRotateNormal, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_useCompoundSpuElf::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_useCompoundSpuElf_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "useCompoundSpuElf"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_useCompoundSpuElf, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxSectorsPerMidphaseCollideTask::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxSectorsPerMidphaseCollideTask_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxSectorsPerMidphaseCollideTask"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxSectorsPerMidphaseCollideTask, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxSectorsPerNarrowphaseCollideTask::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxSectorsPerNarrowphaseCollideTask_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxSectorsPerNarrowphaseCollideTask"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxSectorsPerNarrowphaseCollideTask, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_processToisMultithreaded::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_processToisMultithreaded_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "processToisMultithreaded"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_processToisMultithreaded, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxEntriesPerToiMidphaseCollideTask::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxEntriesPerToiMidphaseCollideTask_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxEntriesPerToiMidphaseCollideTask"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxEntriesPerToiMidphaseCollideTask, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxEntriesPerToiNarrowphaseCollideTask::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxEntriesPerToiNarrowphaseCollideTask_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxEntriesPerToiNarrowphaseCollideTask"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxEntriesPerToiNarrowphaseCollideTask, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_maxNumToiCollisionPairsSinglethreaded::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( int ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_maxNumToiCollisionPairsSinglethreaded_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxNumToiCollisionPairsSinglethreaded"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxNumToiCollisionPairsSinglethreaded, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_numToisTillAllowedPenetrationSimplifiedToi::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_numToisTillAllowedPenetrationSimplifiedToi_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numToisTillAllowedPenetrationSimplifiedToi"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numToisTillAllowedPenetrationSimplifiedToi, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_numToisTillAllowedPenetrationToi::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_numToisTillAllowedPenetrationToi_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numToisTillAllowedPenetrationToi"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numToisTillAllowedPenetrationToi, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_numToisTillAllowedPenetrationToiHigher::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_numToisTillAllowedPenetrationToiHigher_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numToisTillAllowedPenetrationToiHigher"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numToisTillAllowedPenetrationToiHigher, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_numToisTillAllowedPenetrationToiForced::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_numToisTillAllowedPenetrationToiForced_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numToisTillAllowedPenetrationToiForced"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numToisTillAllowedPenetrationToiForced, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_enableDeactivation::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_enableDeactivation_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableDeactivation"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableDeactivation, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_simulationType::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkEnum< hkpWorldCinfo::SimulationType, hkReflect::Typedef::hkInt8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "simulationType"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_simulationType, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpWorldCinfo::_Auto::isValid_m_simulationType),))
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_enableSimulationIslands::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_enableSimulationIslands_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "enableSimulationIslands"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_enableSimulationIslands, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_minDesiredIslandSize::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkUint32_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_minDesiredIslandSize_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "minDesiredIslandSize"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_minDesiredIslandSize, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_processActionsInSingleThread::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_processActionsInSingleThread_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "processActionsInSingleThread"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_processActionsInSingleThread, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "allowIntegrationOfIslandsWithoutConstraintsInASeparateJob"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_frameMarkerPsiSnap::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_frameMarkerPsiSnap_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "frameMarkerPsiSnap"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_frameMarkerPsiSnap, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::TypeData hkpWorldCinfo::_Auto::m_fireCollisionCallbacks::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpWorldCinfo_m_fireCollisionCallbacks_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "fireCollisionCallbacks"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_fireCollisionCallbacks, hkpWorldCinfo)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpWorldCinfo )),
};;

const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,54> hkpWorldCinfo::_Auto::Decls::decls = 
{
    { 54, 0, 54, 0 }, {
        reinterpret_cast<const hkReflect::Type*>(&m_gravity::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_broadPhaseQuerySize::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_contactRestingVelocity::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_broadPhaseType::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_broadPhaseBorderBehaviour::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_mtPostponeAndSortBroadPhaseBorderCallbacks::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_broadPhaseWorldAabb::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_collisionTolerance::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_collisionFilter::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_convexListFilter::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_expectedMaxLinearVelocity::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_sizeOfToiEventQueue::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_expectedMinPsiDeltaTime::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_memoryWatchDog::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_broadPhaseNumMarkers::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_contactPointGeneration::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_allowToSkipConfirmedCallbacks::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_solverTau::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_solverDamp::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_solverIterations::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_solverMicrosteps::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxConstraintViolation::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_forceCoherentConstraintOrderingInSolver::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_snapCollisionToConvexEdgeThreshold::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_snapCollisionToConcaveEdgeThreshold::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableToiWeldRejection::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableDeprecatedWelding::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_iterativeLinearCastEarlyOutDistance::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_iterativeLinearCastMaxIterations::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_deactivationNumInactiveFramesSelectFlag0::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_deactivationNumInactiveFramesSelectFlag1::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_deactivationIntegrateCounter::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_shouldActivateOnRigidBodyTransformChange::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_deactivationReferenceDistance::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_toiCollisionResponseRotateNormal::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_useCompoundSpuElf::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxSectorsPerMidphaseCollideTask::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxSectorsPerNarrowphaseCollideTask::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_processToisMultithreaded::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxEntriesPerToiMidphaseCollideTask::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxEntriesPerToiNarrowphaseCollideTask::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxNumToiCollisionPairsSinglethreaded::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numToisTillAllowedPenetrationSimplifiedToi::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numToisTillAllowedPenetrationToi::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numToisTillAllowedPenetrationToiHigher::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numToisTillAllowedPenetrationToiForced::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableDeactivation::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_simulationType::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_enableSimulationIslands::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_minDesiredIslandSize::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_processActionsInSingleThread::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_allowIntegrationOfIslandsWithoutConstraintsInASeparateJob::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_frameMarkerPsiSnap::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_fireCollisionCallbacks::typeData),
 }};

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#if defined(HK_INCLUDE_VALIDATE_INLINES) || defined(HK_DETAIL_REFLECT_DEFINITIONS)
HK_REFLECT_VALIDATE_INLINE bool hkpWorldCinfo::reflectValidate() const { return hkpWorldCinfo::_Auto::isValid(*this); };
#endif
#if defined(HK_MEMORY_TRACKER_ENABLE) && defined(HK_DETAIL_REFLECT_DEFINITIONS)
hkReflect::Detail::TrackerRegNode hkpWorldCinfo_trackerRegNode( hkReflect::ReflectionOf< hkpWorldCinfo >::Holder::typeData, HK_TRACKER_GET_HANDLE_UNCHECKED( hkpWorldCinfo::_OldMacroHack ), false );
#endif

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hkpWorldCinfo::SolverType
//

hkReflect::Detail::TypeRegNode hkpWorldCinfo_SolverType_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo::SolverType ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo::SolverType >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hkpWorldCinfo::SolverType >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hkpWorldCinfo::SolverType >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo::SolverType"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hkpWorldCinfo_SolverType_Auto::SolverType_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo::SolverType),HK_ALIGN_OF(hkpWorldCinfo::SolverType),0)),    
};
const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_INVALID = static_cast< hkpWorldCinfo::SolverType >(0);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_2ITERS_SOFT = static_cast< hkpWorldCinfo::SolverType >(1);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_2ITERS_MEDIUM = static_cast< hkpWorldCinfo::SolverType >(2);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_2ITERS_HARD = static_cast< hkpWorldCinfo::SolverType >(3);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_4ITERS_SOFT = static_cast< hkpWorldCinfo::SolverType >(4);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_4ITERS_MEDIUM = static_cast< hkpWorldCinfo::SolverType >(5);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_4ITERS_HARD = static_cast< hkpWorldCinfo::SolverType >(6);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_8ITERS_SOFT = static_cast< hkpWorldCinfo::SolverType >(7);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_8ITERS_MEDIUM = static_cast< hkpWorldCinfo::SolverType >(8);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_8ITERS_HARD = static_cast< hkpWorldCinfo::SolverType >(9);

const hkpWorldCinfo::SolverType hkpWorldCinfo_SolverType_Auto::hkPresets_SOLVER_TYPE_MAX_ID = static_cast< hkpWorldCinfo::SolverType >(10);

const char* const hkpWorldCinfo_SolverType_Auto::hkPresets_names[] = {"SOLVER_TYPE_INVALID","SOLVER_TYPE_2ITERS_SOFT","SOLVER_TYPE_2ITERS_MEDIUM","SOLVER_TYPE_2ITERS_HARD","SOLVER_TYPE_4ITERS_SOFT","SOLVER_TYPE_4ITERS_MEDIUM","SOLVER_TYPE_4ITERS_HARD","SOLVER_TYPE_8ITERS_SOFT","SOLVER_TYPE_8ITERS_MEDIUM","SOLVER_TYPE_8ITERS_HARD","SOLVER_TYPE_MAX_ID" };

const void* const hkpWorldCinfo_SolverType_Auto::hkPresets_value[] = { &hkPresets_SOLVER_TYPE_INVALID, &hkPresets_SOLVER_TYPE_2ITERS_SOFT, &hkPresets_SOLVER_TYPE_2ITERS_MEDIUM, &hkPresets_SOLVER_TYPE_2ITERS_HARD, &hkPresets_SOLVER_TYPE_4ITERS_SOFT, &hkPresets_SOLVER_TYPE_4ITERS_MEDIUM, &hkPresets_SOLVER_TYPE_4ITERS_HARD, &hkPresets_SOLVER_TYPE_8ITERS_SOFT, &hkPresets_SOLVER_TYPE_8ITERS_MEDIUM, &hkPresets_SOLVER_TYPE_8ITERS_HARD, &hkPresets_SOLVER_TYPE_MAX_ID };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hkpWorldCinfo_SolverType_Auto::SolverType_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hkpWorldCinfo::SolverType >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hkpWorldCinfo::SolverType >::presets = { true, HK_REFLECT_GET_TYPE( hkpWorldCinfo::SolverType ), 11, hkpWorldCinfo_SolverType_Auto::hkPresets_names, hkpWorldCinfo_SolverType_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hkpWorldCinfo::SimulationType
//

hkReflect::Detail::TypeRegNode hkpWorldCinfo_SimulationType_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo::SimulationType ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo::SimulationType >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hkpWorldCinfo::SimulationType >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hkpWorldCinfo::SimulationType >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo::SimulationType"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hkpWorldCinfo_SimulationType_Auto::SimulationType_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo::SimulationType),HK_ALIGN_OF(hkpWorldCinfo::SimulationType),0)),    
};
const hkpWorldCinfo::SimulationType hkpWorldCinfo_SimulationType_Auto::hkPresets_SIMULATION_TYPE_INVALID = static_cast< hkpWorldCinfo::SimulationType >(0);

const hkpWorldCinfo::SimulationType hkpWorldCinfo_SimulationType_Auto::hkPresets_SIMULATION_TYPE_DISCRETE = static_cast< hkpWorldCinfo::SimulationType >(1);

const hkpWorldCinfo::SimulationType hkpWorldCinfo_SimulationType_Auto::hkPresets_SIMULATION_TYPE_CONTINUOUS = static_cast< hkpWorldCinfo::SimulationType >(2);

const hkpWorldCinfo::SimulationType hkpWorldCinfo_SimulationType_Auto::hkPresets_SIMULATION_TYPE_MULTITHREADED = static_cast< hkpWorldCinfo::SimulationType >(3);

const char* const hkpWorldCinfo_SimulationType_Auto::hkPresets_names[] = {"SIMULATION_TYPE_INVALID","SIMULATION_TYPE_DISCRETE","SIMULATION_TYPE_CONTINUOUS","SIMULATION_TYPE_MULTITHREADED" };

const void* const hkpWorldCinfo_SimulationType_Auto::hkPresets_value[] = { &hkPresets_SIMULATION_TYPE_INVALID, &hkPresets_SIMULATION_TYPE_DISCRETE, &hkPresets_SIMULATION_TYPE_CONTINUOUS, &hkPresets_SIMULATION_TYPE_MULTITHREADED };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hkpWorldCinfo_SimulationType_Auto::SimulationType_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hkpWorldCinfo::SimulationType >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hkpWorldCinfo::SimulationType >::presets = { true, HK_REFLECT_GET_TYPE( hkpWorldCinfo::SimulationType ), 4, hkpWorldCinfo_SimulationType_Auto::hkPresets_names, hkpWorldCinfo_SimulationType_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hkpWorldCinfo::ContactPointGeneration
//

hkReflect::Detail::TypeRegNode hkpWorldCinfo_ContactPointGeneration_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo::ContactPointGeneration ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo::ContactPointGeneration >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hkpWorldCinfo::ContactPointGeneration >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hkpWorldCinfo::ContactPointGeneration >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo::ContactPointGeneration"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hkpWorldCinfo_ContactPointGeneration_Auto::ContactPointGeneration_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo::ContactPointGeneration),HK_ALIGN_OF(hkpWorldCinfo::ContactPointGeneration),0)),    
};
const hkpWorldCinfo::ContactPointGeneration hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_CONTACT_POINT_ACCEPT_ALWAYS = static_cast< hkpWorldCinfo::ContactPointGeneration >(0);

const hkpWorldCinfo::ContactPointGeneration hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_CONTACT_POINT_REJECT_DUBIOUS = static_cast< hkpWorldCinfo::ContactPointGeneration >(1);

const hkpWorldCinfo::ContactPointGeneration hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_CONTACT_POINT_REJECT_MANY = static_cast< hkpWorldCinfo::ContactPointGeneration >(2);

const char* const hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_names[] = {"CONTACT_POINT_ACCEPT_ALWAYS","CONTACT_POINT_REJECT_DUBIOUS","CONTACT_POINT_REJECT_MANY" };

const void* const hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_value[] = { &hkPresets_CONTACT_POINT_ACCEPT_ALWAYS, &hkPresets_CONTACT_POINT_REJECT_DUBIOUS, &hkPresets_CONTACT_POINT_REJECT_MANY };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hkpWorldCinfo_ContactPointGeneration_Auto::ContactPointGeneration_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hkpWorldCinfo::ContactPointGeneration >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hkpWorldCinfo::ContactPointGeneration >::presets = { true, HK_REFLECT_GET_TYPE( hkpWorldCinfo::ContactPointGeneration ), 3, hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_names, hkpWorldCinfo_ContactPointGeneration_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hkpWorldCinfo::BroadPhaseType
//

hkReflect::Detail::TypeRegNode hkpWorldCinfo_BroadPhaseType_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo::BroadPhaseType ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo::BroadPhaseType >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hkpWorldCinfo::BroadPhaseType >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hkpWorldCinfo::BroadPhaseType >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo::BroadPhaseType"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hkpWorldCinfo_BroadPhaseType_Auto::BroadPhaseType_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo::BroadPhaseType),HK_ALIGN_OF(hkpWorldCinfo::BroadPhaseType),0)),    
};
const hkpWorldCinfo::BroadPhaseType hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_BROADPHASE_TYPE_SAP = static_cast< hkpWorldCinfo::BroadPhaseType >(0);

const hkpWorldCinfo::BroadPhaseType hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_BROADPHASE_TYPE_TREE = static_cast< hkpWorldCinfo::BroadPhaseType >(1);

const hkpWorldCinfo::BroadPhaseType hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_BROADPHASE_TYPE_HYBRID = static_cast< hkpWorldCinfo::BroadPhaseType >(2);

const char* const hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_names[] = {"BROADPHASE_TYPE_SAP","BROADPHASE_TYPE_TREE","BROADPHASE_TYPE_HYBRID" };

const void* const hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_value[] = { &hkPresets_BROADPHASE_TYPE_SAP, &hkPresets_BROADPHASE_TYPE_TREE, &hkPresets_BROADPHASE_TYPE_HYBRID };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hkpWorldCinfo_BroadPhaseType_Auto::BroadPhaseType_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hkpWorldCinfo::BroadPhaseType >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hkpWorldCinfo::BroadPhaseType >::presets = { true, HK_REFLECT_GET_TYPE( hkpWorldCinfo::BroadPhaseType ), 3, hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_names, hkpWorldCinfo_BroadPhaseType_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// Enum: hkpWorldCinfo::BroadPhaseBorderBehaviour
//

hkReflect::Detail::TypeRegNode hkpWorldCinfo_BroadPhaseBorderBehaviour_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpWorldCinfo::BroadPhaseBorderBehaviour ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpWorldCinfo::BroadPhaseBorderBehaviour >::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::ATTRIBUTES | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfInt< hkpWorldCinfo::BroadPhaseBorderBehaviour >::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::IntImplN< hkTrait::CorrespondingIntType< hkpWorldCinfo::BroadPhaseBorderBehaviour >::Type >::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpWorldCinfo::BroadPhaseBorderBehaviour"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ATTRIBUTES, reinterpret_cast<const hkReflect::Detail::AttributeArray*>(&hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::BroadPhaseBorderBehaviour_attributes)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpWorldCinfo::BroadPhaseBorderBehaviour),HK_ALIGN_OF(hkpWorldCinfo::BroadPhaseBorderBehaviour),0)),    
};
const hkpWorldCinfo::BroadPhaseBorderBehaviour hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_BROADPHASE_BORDER_ASSERT = static_cast< hkpWorldCinfo::BroadPhaseBorderBehaviour >(0);

const hkpWorldCinfo::BroadPhaseBorderBehaviour hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_BROADPHASE_BORDER_FIX_ENTITY = static_cast< hkpWorldCinfo::BroadPhaseBorderBehaviour >(1);

const hkpWorldCinfo::BroadPhaseBorderBehaviour hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_BROADPHASE_BORDER_REMOVE_ENTITY = static_cast< hkpWorldCinfo::BroadPhaseBorderBehaviour >(2);

const hkpWorldCinfo::BroadPhaseBorderBehaviour hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_BROADPHASE_BORDER_DO_NOTHING = static_cast< hkpWorldCinfo::BroadPhaseBorderBehaviour >(3);

const char* const hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_names[] = {"BROADPHASE_BORDER_ASSERT","BROADPHASE_BORDER_FIX_ENTITY","BROADPHASE_BORDER_REMOVE_ENTITY","BROADPHASE_BORDER_DO_NOTHING" };

const void* const hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_value[] = { &hkPresets_BROADPHASE_BORDER_ASSERT, &hkPresets_BROADPHASE_BORDER_FIX_ENTITY, &hkPresets_BROADPHASE_BORDER_REMOVE_ENTITY, &hkPresets_BROADPHASE_BORDER_DO_NOTHING };

const hkReflect::Detail::FixedArrayStorage<hkUlong, hkReflect::Detail::AttributeItem,1> hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::BroadPhaseBorderBehaviour_attributes = 
{
    1,
    {
        { &hkReflect::Detail::PresetsOf< hkpWorldCinfo::BroadPhaseBorderBehaviour >::presets, HK_REFLECT_GET_TYPE( hk::Presets ) }
    }
};

const hk::Presets hkReflect::Detail::PresetsOf< hkpWorldCinfo::BroadPhaseBorderBehaviour >::presets = { true, HK_REFLECT_GET_TYPE( hkpWorldCinfo::BroadPhaseBorderBehaviour ), 4, hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_names, hkpWorldCinfo_BroadPhaseBorderBehaviour_Auto::hkPresets_value, 0 };

#endif // HK_DETAIL_REFLECT_DEFINITIONS



#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic pop
#endif

#if 0
//)exclude2";
#endif

/*
 * Havok SDK - Generated
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
