// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/hkpWorld.h>

/// Class hkpWorldMemoryUtil
class HK_EXPORT_PHYSICS_2012 hkpWorldMemoryUtil
{
    public:
            /// This checks the amount of free heap memory available in Havok memory system.
            /// If the memory is less than amount required by the hkWorldMemoryAvailableWatchDog,
            /// it calls the watchdog's freeHeapMemoryTillRequestedAmountIsAvailable() function to remove objects from the hkpWorld
            /// until the available memory requirement is met.
        static void HK_CALL watchHeapMemory( hkpWorld* world );

            /// This ensures enough memory is available for the integration step.
            /// The amount of memory needed for integration is know ahead, so we can remove
            /// objects as needed.
        static void HK_CALL checkMemoryForIntegration( hkpWorld* world );

            /// This attempts to remove objects from physics and run collision detection again
            /// to recover from failure in the last step.
        static void HK_CALL tryToRecoverFromMemoryErrors( hkpWorld* world );

    private:

        static void HK_CALL repeatCollideAndToiHandling( hkpWorld* world );

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
