// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpWorld;
struct hkpConstraintBrokenEvent;
struct hkpConstraintRepairedEvent;
class hkStepInfo;
class hkpPhantom;
class hkpContactImpulseLimitBreachedListener;
class HK_EXPORT_PHYSICS_2012 hkpContactImpulseLimitBreachedListenerInfo;

#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

class HK_EXPORT_PHYSICS_2012 hkpWorldCallbackUtil
{
    public:
        static void HK_CALL fireActionAdded( hkpWorld* world, hkpAction* action ) ;
        static void HK_CALL fireActionRemoved( hkpWorld* world, hkpAction* action ) ;

        static void HK_CALL fireEntityAdded( hkpWorld* world, hkpEntity* entity ) ;
        static void HK_CALL fireEntityRemoved( hkpWorld* world, hkpEntity* entity ) ;
        static void HK_CALL fireEntityShapeSet( hkpWorld* world, hkpEntity* entity ) ;
        static void HK_CALL fireEntitySetMotionType( hkpWorld* world, hkpEntity* entity ) ;

        static void HK_CALL firePhantomAdded(    hkpWorld* world, hkpPhantom* phantom );
        static void HK_CALL firePhantomRemoved(  hkpWorld* world, hkpPhantom* phantom );
        static void HK_CALL firePhantomShapeSet( hkpWorld* world, hkpPhantom* phantom ) ;

        static void HK_CALL fireConstraintAdded(   hkpWorld* world, hkpConstraintInstance* constraint ) ;
        static void HK_CALL fireConstraintRemoved( hkpWorld* world, hkpConstraintInstance* constraint ) ;
        static void HK_CALL fireConstraintViolated( hkpWorld* world, hkpConstraintInstance* constraint ) ;
        static void HK_CALL fireConstraintBroken( hkpWorld* world, const hkpConstraintBrokenEvent& event ) ;
        static void HK_CALL fireConstraintRepaired( hkpWorld* world, const hkpConstraintRepairedEvent& event ) ;

#if !defined(HK_PLATFORM_SPU)
        static void HK_CALL fireContactPointCallback( hkpWorld* world, hkpContactPointEvent& event );
        static void HK_CALL fireContactConstraintAddedCallback( hkpWorld* world, hkpCollisionEvent& event );
        static void HK_CALL fireContactConstraintRemovedCallback( hkpWorld* world, hkpCollisionEvent& event );
#endif

        static void HK_CALL firePostSimulationCallback( hkpWorld* world );
        static void HK_CALL firePostIntegrateCallback( hkpWorld* world, const hkStepInfo& info );
        static void HK_CALL firePostCollideCallback( hkpWorld* world, const hkStepInfo& info );

            // This fires both island and entity activation callbacks.
        static void HK_CALL fireIslandActivated( hkpWorld* world, hkpSimulationIsland* island );
            // This fires both island and entity deactivation callbacks.
        static void HK_CALL fireIslandDeactivated( hkpWorld* world, hkpSimulationIsland* island );

        static void HK_CALL fireIslandPostIntegrateCallback( hkpWorld* world, hkpSimulationIsland* island, const hkStepInfo& info );
        static void HK_CALL fireIslandPostCollideCallback( hkpWorld* world, hkpSimulationIsland* island, const hkStepInfo& info );

        static void HK_CALL fireWorldDeleted( hkpWorld* world ) ;
        static void HK_CALL fireWorldRemoveAll( hkpWorld* world ) ;


        static void HK_CALL fireInactiveEntityMoved( hkpWorld* world, hkpEntity* entity);

        static void HK_CALL fireContactImpulseLimitBreached( hkpWorld* world, const hkpContactImpulseLimitBreachedListenerInfo* breachedContacts, int numBreachedContacts );

        //
        // Deprecated.
        //
        static void HK_CALL fireContactPointAdded( hkpWorld* world, hkpContactPointAddedEvent& event);
        static void HK_CALL fireContactPointRemoved( hkpWorld* world, hkpContactPointRemovedEvent& event );
        static void HK_CALL fireContactProcess( hkpWorld* world, hkpContactProcessEvent& event );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
