// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Common/Base/Types/Physics/hkStepInfo.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>
#include <Physics2012/Dynamics/Action/hkpAction.h>
//#include <hkdynamics/action/hkNullActionCinfo.h>

class hkpEntity;
class hkpPhantom;
class hkpSimulationIsland;
class hkStepInfo;
class hkpWorld;

/// This is the base class from which user actions (or controllers) are derived. Actions
/// are the interface between user controllable behavior of the physical simulation and the Havok core.
class HK_EXPORT_PHYSICS_2012 hkpNullAction : public hkpAction
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_ACTION);

        inline hkpNullAction() : hkpAction(0) {}

        virtual void applyAction( const hkStepInfo& stepInfo )      {}

        virtual void getEntities( hkArray<hkpEntity*>& entitiesOut ) {}

        virtual void entityRemovedCallback(hkpEntity* entity)        {}

        virtual hkpAction* clone( const hkArray<hkpEntity*>& entitiesIn, const hkArray<hkpPhantom*>& newPhantoms  ) const  { return HK_NULL; }

        static inline hkpNullAction* HK_CALL getNullAction(){ return HK_NULL; }

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
