// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/World/Util/BroadPhase/hkpBroadPhaseBorderListener.h>
#include <Physics2012/Dynamics/Phantom/hkpPhantom.h>
#include <Physics2012/Collide/Dispatch/BroadPhase/hkpTypedBroadPhaseHandlePair.h>


void hkpBroadPhaseBorderListener::addCollisionPair( hkpTypedBroadPhaseHandlePair& pair )
{
    if (   pair.getElementA()->getType() == hkpWorldObject::BROAD_PHASE_BORDER
        && pair.getElementB()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        return;
    }
    if ( pair.getElementA()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        hkpCollidable* collA = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_a)->getOwner() );
        hkpCollidable* collB = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_b)->getOwner() );
        hkpPhantom* p = static_cast<hkpPhantom*>( collA->getOwner() );
        p->addOverlappingCollidable( collB );
    }

    if ( pair.getElementB()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        hkpCollidable* collA = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_a)->getOwner() );
        hkpCollidable* collB = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_b)->getOwner() );
        hkpPhantom* p = static_cast<hkpPhantom*>( collB->getOwner() );
        p->addOverlappingCollidable( collA );
    }
}


void hkpBroadPhaseBorderListener::removeCollisionPair( hkpTypedBroadPhaseHandlePair& pair )
{
    if (   pair.getElementA()->getType() == hkpWorldObject::BROAD_PHASE_BORDER
        && pair.getElementB()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        return;
    }

    if ( pair.getElementA()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        hkpCollidable* collA = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_a)->getOwner() );
        hkpCollidable* collB = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_b)->getOwner() );
        hkpPhantom* p = static_cast<hkpPhantom*>( collA->getOwner() );
        p->removeOverlappingCollidable( collB );
    }

    if ( pair.getElementB()->getType() == hkpWorldObject::BROAD_PHASE_BORDER )
    {
        hkpCollidable* collA = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_a)->getOwner() );
        hkpCollidable* collB = static_cast<hkpCollidable*>( static_cast<hkpTypedBroadPhaseHandle*>(pair.m_b)->getOwner() );
        hkpPhantom* p = static_cast<hkpPhantom*>( collB->getOwner() );
        p->removeOverlappingCollidable( collA );
    }

}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
