// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/CommandQueue/hkpPhysicsCommandQueue.h>
#include <Physics2012/Dynamics/Constraint/hkpConstraintOwner.h>
#include <Physics2012/Dynamics/World/Simulation/Multithreaded/hkpDynamicsJobs.h>

class HK_EXPORT_PHYSICS_2012 hkpDeferredConstraintOwner: public hkpConstraintOwner
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        enum { FIXED_QUEUE_LENGTH = hkpPhysicsCommandQueue::BYTES_PER_COMMAND * hkpAgentBaseJob::MAX_AGENT_NN_ENTRIES_PER_TASK };

    public:
        HK_INLINE hkpDeferredConstraintOwner()
        {
            m_constraintInfo.clear();
            m_constraintAddRemoveCounter = 0;
            m_callbackRequestForAddConstraint = 0;
        }

        virtual void addConstraintToCriticalLockedIsland( hkpConstraintInstance* constraint )
        {
#if defined (HK_PLATFORM_SPU)
            m_constraintForCommand = m_constraintOnPpu;
#else
            m_constraintForCommand = constraint;
#endif

            m_constraintAddRemoveCounter = m_constraintAddRemoveCounter + 1;
        }

        virtual void removeConstraintFromCriticalLockedIsland( hkpConstraintInstance* constraint )
        {
#if defined (HK_PLATFORM_SPU)
            m_constraintForCommand = m_constraintOnPpu;
#else
            m_constraintForCommand = constraint;
#endif

            m_constraintAddRemoveCounter = m_constraintAddRemoveCounter - 1;
        }

        void addCallbackRequest( hkpConstraintInstance* constraint, int request )
        {
            if ( constraint->m_internal )
            {
                constraint->m_internal->m_callbackRequest |= request;
            }
            else
            {
                m_callbackRequestForAddConstraint = m_callbackRequestForAddConstraint | request;
            }
        }


        int m_constraintAddRemoveCounter;

        hkpConstraintInstance* m_constraintForCommand;
#if defined (HK_PLATFORM_HAS_SPU)
        hkpConstraintInstance* m_constraintOnPpu;
#endif
        int m_callbackRequestForAddConstraint;

        hkpFixedSizePhysicsCommandQueue<FIXED_QUEUE_LENGTH> m_commandQueue;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
