// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/JobQueue/hkJobQueue.h>

#include <Physics2012/Dynamics/World/Simulation/Multithreaded/hkpDynamicsJobQueueUtils.h>
#include <Physics2012/Dynamics/World/Simulation/Multithreaded/hkpMultithreadedSimulation.h>
#include <Physics2012/Collide/Agent3/Machine/Nn/hkpAgentNnMachine.h>
#include <Physics2012/Collide/Agent/hkpProcessCollisionOutput.h>
#include <Physics2012/Collide/Agent/ContactMgr/hkpContactMgr.h>


//
hkJobQueue::JobStatus HK_CALL hkCpuAgentSectorJob(  hkpMtThreadStructure&       tl,
                                                    hkJobQueue&                 jobQueue,
                                                    hkJobQueue::JobQueueEntry&  nextJobOut );

//
HK_INLINE void HK_CALL hkCpuProcessAgentHelperFunc( hkpAgentNnEntry*                entry,
                                                            const hkpProcessCollisionInput& input,
                                                            hkpProcessCollisionOutput&      processOutput,
                                                            hkpMultiThreadedSimulation*     simulation )
{
    hkpCollidable* collA = entry->getCollidableA();
    hkpCollidable* collB = entry->getCollidableB();

    {
        input.m_collisionQualityInfo = input.m_dispatcher->getCollisionQualityInfo( entry->m_collisionQualityIndex );
        input.m_createPredictiveAgents = input.m_collisionQualityInfo->m_useContinuousPhysics;

        processOutput.reset();

        hkAgentNnMachine_ProcessAgent( entry, input, processOutput, entry->m_contactMgr );

        if ( !processOutput.isEmpty() )
        {
            entry->m_contactMgr->processContact( *collA, *collB, input, processOutput );
        }

        if ( processOutput.hasToi() )
        {
            HK_ASSERT_NO_MSG( 0xf0324354, input.m_stepInfo.m_startTime <= processOutput.m_toi.m_time );
            HK_ASSERT(0xad8765dd, processOutput.m_toi.m_time >= simulation->getCurrentTime(), "Generating a TOI event before hkpWorld->m_currentTime.");

            simulation->addToiEventWithCriticalSectionLock(processOutput, *entry, &simulation->m_toiQueueCriticalSection );
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
