// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL !REFLECT
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Physics2012/Dynamics/World/Simulation/Continuous/ToiResourceMgr/hkpToiResourceMgr.h>


class hkpWorld;
class hkStepInfo;




class hkpDefaultToiResourceMgr : public hkpToiResourceMgr
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        hkpDefaultToiResourceMgr();
        ~hkpDefaultToiResourceMgr();


            /// Return HK_SUCCESS when the passed TOI event should be processed, failure otherwise (don't need to call endToi then).
        virtual hkResult beginToiAndSetupResources(const hkpToiEvent& event, const hkArray<hkpToiEvent>& otherEvents, hkpToiResources& resourcesOut );


            // hkpToiResourceMgr interface implementations
        virtual hkpToiResourceMgrResponse cannotSolve(hkArray<ConstraintViolationInfo>& violatedConstraints);


            // hkpToiResourceMgr interface implementations
        virtual hkpToiResourceMgrResponse resourcesDepleted();


            // hkpToiResourceMgr interface implementations
        virtual void endToiAndFreeResources(const hkpToiEvent& event, const hkArray<hkpToiEvent>& otherEvents, const hkpToiResources& resources );

        virtual int getScratchpadCapacity();

    private:
        hkBool shouldHandleGivenToi( const hkpToiEvent& event );
        int m_scratchPadCapacity;

    public:
        int m_defaultScratchpadSize;

            /// The default priority class map, which has three classes.
        static const hkUint8 s_priorityClassMap[];
            /// The default ratios.
        static const hkReal s_priorityClassRatios[];
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
