// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/Simulation/Continuous/hkpContinuousSimulation.h>

    // Simplified continuous simulation
class HK_EXPORT_PHYSICS_2012 hkpBackstepSimulation : public hkpContinuousSimulation
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Backstepping mode
        enum BackstepMode
        {
                /// Performs only a single call to continuous collision detection. Does not recollide continuously backstepped bodies.
                /// For that reason this mode is only useful when dynamic bodies are collided continuously _only_ against landscape.
            SIMPLE,
                /// Performs multiple calls to continuous collision detection. Guarantees non-penetration according to surface qualities.
            NON_PENETRATING
        };


        hkpBackstepSimulation( hkpWorld* world, enum BackstepMode backstepMode = NON_PENETRATING );

    protected:

        virtual void simulateToi( hkpWorld* world, hkpToiEvent& event, hkReal physicsDeltaTime, hkReal rotateNormal );

        BackstepMode m_backsteppingMode;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
