// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/Maintenance/hkpWorldMaintenanceMgr.h>

/// Class hkpDefaultWorldMaintenanceMgr
class HK_EXPORT_PHYSICS_2012 hkpDefaultWorldMaintenanceMgr : public hkpWorldMaintenanceMgr
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

        hkpDefaultWorldMaintenanceMgr();

        virtual void init( hkpWorld* world );

            /// ###ACCESS_CHECKS###( [world,HK_ACCESS_RW] );
        virtual void performMaintenance( hkpWorld* world, hkStepInfo& stepInfo );

            // do all maintenance but ignore island split checks. This is used for multithreaded simulation, where
            // the split check is done in parallel to the solve job
            /// ###ACCESS_CHECKS###( [world,HK_ACCESS_RW] );
        virtual void performMaintenanceNoSplit( hkpWorld* world, hkStepInfo& stepInfo );

    private:

            /// ###ACCESS_CHECKS###( [world,HK_ACCESS_RW] );
        inline void resetWorldTime( hkpWorld* world, hkStepInfo& stepInfo );

            // this is the old Havok400 style deactivation checks at the beginning of each frame
            /// ###ACCESS_CHECKS###( [world,HK_ACCESS_RW] );
        inline void markIslandsForDeactivationDeprecated( hkpWorld* world, hkStepInfo& stepInfo );

    protected:

        /// A range within the time variable will be held
        hkReal m_minAllowedTimeValue;
        hkReal m_maxAllowedTimeValue;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
