// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpWorld;
class hkpEntity;
class hkStepInfo;

    /// Derive from this class to receive callbacks after all entities have been simulated.
class HK_EXPORT_PHYSICS_2012 hkpWorldPostSimulationListener
{
    public:
        HK_DECLARE_CLASS(hkpWorldPostSimulationListener, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::Serialize(false));

        virtual ~hkpWorldPostSimulationListener() {}

            /// Called at the end of the hkpWorld::simulate call.
        virtual void postSimulationCallback( hkpWorld* world ) = 0;

            /// Called when an inactive/fixed entity is moved in the hkpWorld.
        virtual void inactiveEntityMovedCallback( hkpEntity* entity ) {}

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
