// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

class hkpWorld;
class hkStepInfo;

    /// Derive from this class to receive callbacks after all collision detection has been performed for all entities.
    /// Add to the world using hkpWorld::addWorldPostCollideListener.
class HK_EXPORT_PHYSICS_2012 hkpWorldPostCollideListener
{
    //+hk.MemoryTracker(ignore=True)
    public:

        virtual ~hkpWorldPostCollideListener() {}

            /// Called after collision detection is performed.
            /// The stepInfo passed to this function is the step info that was used to process
            /// the last psi (integrate and collide). When this function is called, the world
            /// current psi time will be the same as the stepInfo end time, (i.e., the psi time
            /// has been incremented), but the world current time will be the same as the step
            /// info start time, as it is not incremented until advanceTime is called.
        virtual void postCollideCallback( hkpWorld* world, const hkStepInfo& stepInfo ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
