// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

void hkpPhysicsCommandQueue::init(hkpPhysicsCommand* bufferStart, int capacity)
{
    m_start.set( bufferStart );
    m_size = 0;
    m_capacity = capacity;
}

hkpPhysicsCommandQueue::hkpPhysicsCommandQueue( hkpPhysicsCommand* bufferStart, int capacity )
{
    init(bufferStart, capacity);
}

template<typename COMMAND_STRUCT>
void hkpPhysicsCommandQueue::addCommand(COMMAND_STRUCT command)
{
    hkpPhysicsCommand* current = hkAddByteOffset( m_start.val(), m_size );
    COMMAND_STRUCT& dest = static_cast<COMMAND_STRUCT&>(*current);
    dest = command;
    int size = HK_NEXT_MULTIPLE_OF(16, sizeof(COMMAND_STRUCT) );
    m_size += size;
    HK_ASSERT( 0xf03234f5, m_size <= m_capacity, "Running out of command buffer" );
}

template<typename COMMAND_STRUCT>
COMMAND_STRUCT& hkpPhysicsCommandQueue::newCommand()
{
    hkpPhysicsCommand* current = hkAddByteOffset( m_start.val(), m_size );
    COMMAND_STRUCT* res = new (current)COMMAND_STRUCT();
    int size = HK_NEXT_MULTIPLE_OF(16, sizeof(COMMAND_STRUCT) );
    m_size += size;
    HK_ASSERT( 0xf03224f5, m_size <= m_capacity, "Running out of command buffer" );
    return *res;
}

template<int NUM_BYTES>
hkpFixedSizePhysicsCommandQueue<NUM_BYTES>::hkpFixedSizePhysicsCommandQueue() :
    hkpPhysicsCommandQueue( (hkpPhysicsCommand*)&m_buffer[0], NUM_BYTES )
{
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
