// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintInfo.h>

    //
    //  The base class of all physics commands
    //
struct HK_EXPORT_PHYSICS_2012 hkpPhysicsCommand
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpPhysicsCommand );

    enum TYPE
    {
        TYPE_ADD_CONSTRAINT_TO_LOCKED_ISLAND,
        TYPE_REMOVE_CONSTRAINT_FROM_LOCKED_ISLAND,
        TYPE_END
    };
    hkpPhysicsCommand(TYPE type): m_type(type){}

    hkEnum<TYPE,hkUchar> m_type;
};


    //
    //  A small helper template class used for simple single object commands
    //
template<hkpPhysicsCommand::TYPE COMMAND_TYPE, typename OBJECT_TYPE>
struct HK_EXPORT_PHYSICS_2012 hkpSingleObjectPhysicsCommand: public hkpPhysicsCommand
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpSingleObjectPhysicsCommand );

    HK_INLINE hkpSingleObjectPhysicsCommand( OBJECT_TYPE object ): hkpPhysicsCommand( COMMAND_TYPE ), m_object(object){}
    OBJECT_TYPE m_object;
};

//
//  A small helper template class used for simple dual object commands
//
template<hkpPhysicsCommand::TYPE COMMAND_TYPE, typename OBJECT_TYPE0, typename OBJECT_TYPE1>
struct HK_EXPORT_PHYSICS_2012 hkpDualObjectPhysicsCommand: public hkpPhysicsCommand
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpDualObjectPhysicsCommand );

    HK_INLINE hkpDualObjectPhysicsCommand( OBJECT_TYPE0 object0, OBJECT_TYPE1 object1 ): hkpPhysicsCommand( COMMAND_TYPE ), m_object0(object0), m_object1(object1){}
    OBJECT_TYPE0 m_object0;
    OBJECT_TYPE1 m_object1;
};

struct HK_EXPORT_PHYSICS_2012 hkpConstraintInfoExtended: public hkpConstraintInfo
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpConstraintInfoExtended );

    hkpConstraintInstance* m_constraint;
};

    //
    //  Simple single objects commands
    //
typedef hkpDualObjectPhysicsCommand  <hkpPhysicsCommand::TYPE_ADD_CONSTRAINT_TO_LOCKED_ISLAND,      class hkpConstraintInstance*,int> hkpAddConstraintToCriticalLockedIslandPhysicsCommand;
typedef hkpSingleObjectPhysicsCommand<hkpPhysicsCommand::TYPE_REMOVE_CONSTRAINT_FROM_LOCKED_ISLAND, class hkpConstraintInstance*> hkpRemoveConstraintFromCriticalLockedIslandPhysicsCommand;


extern void HK_CALL hkPhysicsCommandMachineProcess( hkpWorld* world, hkpPhysicsCommand* begin, int sizeOfAllCommandsInBytes );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
