// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>
#include <Physics2012/Dynamics/Phantom/hkpPhantomOverlapListener.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldDeletionListener.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>

class hkpWorld;
class hkpEntity;

/// This class monitors objects leaving the broadphase.
class HK_EXPORT_PHYSICS_2012 hkpBroadPhaseBorder : public hkReferencedObject, protected hkpWorldDeletionListener, protected hkpPhantomOverlapListener, protected hkpWorldPostSimulationListener
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

            /// Creates an instance and attaches it to the world. It also adds a second reference to it that gets removed when the world gets deleted.
            /// The positions of the border phantoms are derived from the broadphase extents of the hkpWorld.
        hkpBroadPhaseBorder( hkpWorld* world, hkpWorldCinfo::BroadPhaseBorderBehaviour type  = hkpWorldCinfo::BROADPHASE_BORDER_ASSERT, hkBool postponeAndSortCallbacks = false );

        virtual ~hkpBroadPhaseBorder();

            /// This function is called when an object goes beyond the scope of the broadphase.
            /// By default, it removes the entity from the world, you may implement your own version.
        virtual void maxPositionExceededCallback( hkpEntity* body );

            /// Deactivate this class.
        virtual void deactivate();

        virtual void collidableAddedCallback( const hkpCollidableAddedEvent& event  );

            /// Callback implementation.
        virtual void collidableRemovedCallback( const hkpCollidableRemovedEvent& event );

            /// Called at the end of the hkpWorld::simulate call.
            /// Handles entities exiting broad phase in the last frame.
        virtual void postSimulationCallback( hkpWorld* world );

    public:

        virtual void worldDeletedCallback( hkpWorld* world );

        hkpWorld* m_world;

        class hkpPhantom* m_phantoms[6];

        hkpWorldCinfo::BroadPhaseBorderBehaviour m_type;

        hkBool m_postponeAndSortCallbacks;

        hkArray<hkpEntity*> m_entitiesExitingBroadPhase;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
