// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Dynamics/Phantom/hkpPhantom.h>

 /// Implement this class and add it to hkpWorld or hkpPhantom
 /// to receive a callback if any of the following events occur
class HK_EXPORT_PHYSICS_2012 hkpPhantomListener
{
    //+hk.MemoryTracker(ignore=True)
    public:
            /// Virtual destructor for derived objects
        virtual ~hkpPhantomListener() {}

            /// Called when an phantom is added to the hkpWorld.
        virtual void phantomAddedCallback( hkpPhantom*  ) {}

            /// Called when an phantom is removed from the hkpWorld.
        virtual void phantomRemovedCallback( hkpPhantom*  ) {}

            /// Called when a phantom changes its shape.
        virtual void phantomShapeSetCallback( hkpPhantom* phantom )
        {
            // Most of Havok's phantom listeners (VDB viewers) are only concerned about phantoms that are in the world.
            if (phantom->getWorld())
            {
                // Since Havok's VDB viewers have do destroy old and create new display information, we can simply call:
                phantomRemovedCallback(phantom);
                phantomAddedCallback(phantom);
            }
        }

            /// Called when an phantom is deleted.
        virtual void phantomDeletedCallback( hkpPhantom*  ) {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
