// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if !defined(HK_PLATFORM_SPU)

/// Helper function that returns a hkpPhantom if the collidable's broadphase handle is of type hkpWorldObject::BROAD_PHASE_PHANTOM
inline hkpPhantom* HK_CALL hkpGetPhantom(const hkpCollidable* collidable)
{
    if ( collidable->getType() == hkpWorldObject::BROAD_PHASE_PHANTOM )
    {
        return static_cast<hkpPhantom*>( hkpGetWorldObject(collidable) );
    }
    return HK_NULL;
}

hkpCollidableAccept hkpPhantom::fireCollidableAdded( const hkpCollidable* collidable )
{
    hkpCollidableAddedEvent event;
    event.m_collidable = collidable;
    event.m_phantom = this;
    event.m_collidableAccept = HK_COLLIDABLE_ACCEPT;

    for ( int i = m_overlapListeners.getSize()-1; i >= 0; i-- )
    {
        if (m_overlapListeners[i] != HK_NULL)
        {
            m_overlapListeners[i]->collidableAddedCallback( event );
        }
    }
    // cleanupNullPointers done at the end of updateBroadPhase
    return event.m_collidableAccept;
}

void hkpPhantom::fireCollidableRemoved( const hkpCollidable* collidable, hkBool collidableWasAdded )
{
    hkpCollidableRemovedEvent event;
    event.m_collidable = collidable;
    event.m_phantom = this;
    event.m_collidableWasAdded = collidableWasAdded;

    for ( int i = m_overlapListeners.getSize()-1; i >= 0; i-- )
    {
        if (m_overlapListeners[i] != HK_NULL)
        {
            m_overlapListeners[i]->collidableRemovedCallback( event );
        }
    }
    // cleanupNullPointers done at the end of updateBroadPhase
}


inline hkpPhantom::hkpPhantom( const hkpShape* shape )
    : hkpWorldObject( shape, BROAD_PHASE_PHANTOM )
{
    m_collidable.setOwner( this );
}

inline const hkArray<hkpPhantomListener*>& hkpPhantom::getPhantomListeners() const
{
    return m_phantomListeners;
}

inline const hkArray<hkpPhantomOverlapListener*>& hkpPhantom::getPhantomOverlapListeners() const
{
    return m_overlapListeners;
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
