// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Motion/MotionState/hkMotionState.h>
#include <Common/Base/Types/Physics/hkStepInfo.h>

/// A set of useful functions changing a hkMotionState or a SweptTransform
namespace hkSweptTransformUtil
{
    /// inline version of lerp2
    HK_INLINE void HK_CALL _lerp2( const hkSweptTransform& sweptTrans, hkReal t, hkQuaternion& quatOut );
    HK_INLINE void HK_CALL _lerp2( const hkSweptTransform& sweptTrans, hkSimdRealParameter t, hkQuaternion& quatOut );

    /// inline version of lerp2
    HK_INLINE void HK_CALL _lerp2( const hkSweptTransform& sweptTrans, hkReal t, hkTransform& transformOut );
    HK_INLINE void HK_CALL _lerp2( const hkSweptTransform& sweptTrans, hkSimdRealParameter t, hkTransform& transformOut );

    /// approximate a transform given an interpolation time
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2(const hkSweptTransform& sweptTrans, hkTime time, hkTransform& transformOut);
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2(const hkSweptTransform& sweptTrans, hkSimdRealParameter time, hkTransform& transformOut);

    // internal function: approximate a transform given an interpolation time with a higher accuracy time input
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2Ha(const hkSweptTransform& sweptTrans, hkTime t, hkReal tAddOn, hkTransform& transformOut);
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2Ha(const hkSweptTransform& sweptTrans, hkSimdRealParameter t, hkSimdRealParameter tAddOn, hkTransform& transformOut);

    /// approximate a transform given an interpolation value r between 0.0f and 1.0f.
    /// This uses an internal modified lerp (=linear interpolation of quaternion) functionality
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2Rel(const hkSweptTransform& sweptTrans, hkReal r, hkTransform& transformOut);
    HK_EXPORT_PHYSICS_2012 void HK_CALL lerp2Rel(const hkSweptTransform& sweptTrans, hkSimdRealParameter r, hkTransform& transformOut);

    /// Calculate the transform at time0
    HK_INLINE void HK_CALL calcTransAtT0( const hkSweptTransform& sweptTrans, hkTransform& transformOut );

    /// Calculate the transform at time1
    HK_INLINE void HK_CALL calcTransAtT1( const hkSweptTransform& sweptTrans, hkTransform& transformOut );

#if 1 || defined(HK_REAL_IS_FLOAT)

    /// Sets the center of mass in local space.
    /// This does not change the position of the object, however it does change m_centerOfMass0 and m_centerOfMass1
    HK_EXPORT_PHYSICS_2012 void HK_CALL setCentreOfRotationLocal(hkVector4Parameter newCenterOfRotation, hkMotionState& sweptTrans);

    /// Step the motion forward in time.
    ///
    /// Notes:
    ///    - The angular velocity is clipped to 0.9*pi*invDeltatime
    HK_INLINE void HK_CALL _stepMotionState( const hkStepInfo& stepInfo, hkVector4& linearVelocity, hkVector4& angularVelocity, hkMotionState& motionState );

    /// clips the input velocities
    HK_INLINE void HK_CALL _clipVelocities( const hkMotionState& motionState, hkVector4& linearVelocity, hkVector4& angularVelocity );

    /// Allows you to integrate a motions state by not using velocities, but by specifying the next mass center position and rotation.
    HK_EXPORT_PHYSICS_2012 void HK_CALL keyframeMotionState(const hkStepInfo& stepInfo, hkVector4Parameter pos1, hkQuaternionParameter rot1, hkMotionState& motionState);

    /// Gets the mass center at a given time t.
    HK_INLINE void HK_CALL calcCenterOfMassAt( const hkMotionState& ms, hkTime t, hkVector4& centerOut );
    HK_INLINE void HK_CALL calcCenterOfMassAt( const hkMotionState& ms, hkSimdRealParameter t, hkVector4& centerOut );

    /// Return the velocity which was used to integrate the motion state from state 0 to state 1
    HK_INLINE void HK_CALL getVelocity( const hkMotionState& ms, hkVector4& linearVelOut, hkVector4& angularVelOut );

    // interpolates the information of t1 to be at time t.
    HK_EXPORT_PHYSICS_2012 void HK_CALL backStepMotionState(hkTime t, hkMotionState& motionState);
    HK_EXPORT_PHYSICS_2012 void HK_CALL backStepMotionState(hkSimdRealParameter t, hkMotionState& motionState);

    // Internal function. Only used upon deactivation of entities
    HK_EXPORT_PHYSICS_2012 void HK_CALL freezeMotionState(hkTime time, hkMotionState& motionState);
    HK_EXPORT_PHYSICS_2012 void HK_CALL freezeMotionState(hkSimdRealParameter time, hkMotionState& motionState);

    // Call this if you deactivate a body (otherwise numerical problems can result in strange extrapolation of body movement)
    HK_INLINE void HK_CALL deactivate( hkMotionState& ms );

    // Internal function. Only used upon activation of entities
    HK_EXPORT_PHYSICS_2012 void HK_CALL setTimeInformation(hkTime startTime, hkReal invDeltaTime, hkMotionState& motionState);
    HK_EXPORT_PHYSICS_2012 void HK_CALL setTimeInformation(hkSimdRealParameter startTime, hkSimdRealParameter invDeltaTime, hkMotionState& motionState);

    /// Warp the geometry center of both frames to position
    HK_EXPORT_PHYSICS_2012 void HK_CALL warpToPosition(hkVector4Parameter position, hkMotionState& ms);

    /// Warp the orientation of both frames to rotations. Note: This changes the m_centerOfMass
    HK_EXPORT_PHYSICS_2012 void HK_CALL warpToRotation(hkQuaternionParameter rotation, hkMotionState& ms);

    /// Warp to position and orientation
    HK_EXPORT_PHYSICS_2012 void HK_CALL warpTo(hkVector4Parameter position, hkQuaternionParameter rotation, hkMotionState& ms);

    /// Warp to a new transform (includes both frames)
    HK_EXPORT_PHYSICS_2012 void HK_CALL warpTo(const hkTransform& transform, hkMotionState& ms);

    // For a given delta time: Calc the relative linear movement (xyz) and the worst case angular movement (w)
    HK_INLINE void HK_CALL calcTimInfo( const hkMotionState& ms0, const hkMotionState& ms1, hkReal deltaTime, hkVector4& timOut);

    // calc the relative angular movement for a reduced step
    HK_INLINE void HK_CALL calcAngularTimInfo( const hkMotionState& ms0, const hkMotionState& ms1, hkReal deltaTime, hkVector4* deltaAngleOut0, hkVector4* deltaAngleOut1 );

#endif // defined(HK_REAL_IS_FLOAT)

    HK_EXPORT_PHYSICS_2012 extern const hkQuadReal _stepMotionStateMaxVelf; 
}

#include <Physics2012/Dynamics/Motion/SweptTransform/hkSweptTransformUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
