// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Motion/Rigid/hkpKeyframedRigidMotion.h>



/// This class is contained by the hkpRigidBody class.
/// It should not be accessed directly by the user.
class HK_EXPORT_PHYSICS_2012 hkpFixedRigidMotion : public hkpKeyframedRigidMotion
{
    public:
        HK_DECLARE_CLASS(hkpFixedRigidMotion, New, Reflect, BypassCtor);

            /// Construct a keyframed rigid body motion object, given position and rotation.
            /// Fixed rigid bodies have infinite mass and so will not move
            /// during simulation. They can never be repositioned as their
            /// bounding volume information will not be properly updated.
        hkpFixedRigidMotion( const hkVector4& position, const hkQuaternion& rotation );

    public:

            /// This method updates the saved motion with the dynamic properties of the current keyframed motion, namely
            /// m_linearVelocity, m_angularVelocity, m_rotation, m_oldCenterOfMassInWorld, m_centerOfMassInWorld and m_localToWorld.
            /// This should always be called before a "keyframed" dynamic body is "unkeyframed" again.
        virtual void getPositionAndVelocities( hkpMotion* motionOut );

        virtual void setStepPosition( hkReal position, hkReal timestep );

            /// This function asserts if it is called.
            /// You cannot set the linear velocity of a fixed rigid motion.
        virtual void setLinearVelocity(const hkVector4& newVel);

            /// This function asserts if it is called.
            /// You cannot set the angular velocity of a fixed rigid motion.
        virtual void setAngularVelocity(const hkVector4& newVel);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
