// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Entity/hkpEntity.h>

/// Any class that is interested in events from an entity inherits from this class. For example, hkConstraints and hkActions are entity listeners.
class HK_EXPORT_PHYSICS_2012 hkpEntityListener
{
    public:
        HK_DECLARE_CLASS(hkpEntityListener, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::Serialize(false));

            /// Virtual destructor for derived objects
        virtual ~hkpEntityListener() {}

            /// Called when an entity is added to the hkpWorld.
        virtual void entityAddedCallback( hkpEntity* entity ) {}

            /// Called when an entity is removed from the hkpWorld.
        virtual void entityRemovedCallback( hkpEntity* entity ) {}

            /// Called when an entity changes its shape.
        virtual void entityShapeSetCallback( hkpEntity* entity)
        {
            // Most of Havok's entity listeners (VDB viewers) are only concerned about entities that are in the world.
            if (entity->getWorld())
            {
                // Since Havok's VDB viewers have do destroy old and create new display information, we can simply call:
                entityRemovedCallback(entity);
                entityAddedCallback(entity);
            }
        }

            /// Called when the motion type of an entity (rigid body) is changed
        virtual void entitySetMotionTypeCallback( hkpEntity* entity ) {}

            /// Called when an entity is deleted. hkpEntityListener subclasses \b must implement this function.
        virtual void entityDeletedCallback( hkpEntity* entity ) {}

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
