// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpEntity;

/// Inherit from this class to receive activation and deactivation events from a given entity.
/// You must add your listener class to the entity with hkpEntity::addEntityActivationListener() to receive these events.
class HK_EXPORT_PHYSICS_2012 hkpEntityActivationListener
{
    //+hk.MemoryTracker(ignore=True)
    public:
        virtual ~hkpEntityActivationListener() {}

            /// Called when an entity is deactivated.
            /// NOTE: Activation and Deactivation callbacks are not symmetrical,
            /// and neither is called directly upon entity addition to or removal
            /// from the hkpWorld. Similarly activation callbacks are not fired
            /// when entities are moved between fixed and dynamic islands.
        virtual void entityDeactivatedCallback(hkpEntity* entity) = 0;

            /// Called when an entity is activated.
            /// NOTE: Activation and Deactivation callbacks are not symmetrical,
            /// and neither is called directly upon entity addition to or removal
            /// from the hkpWorld. Similarly activation callbacks are not fired
            /// when entities are moved between fixed and dynamic islands.
        virtual void entityActivatedCallback(hkpEntity* entity) = 0;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
