// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkpMotion* hkpEntity::getMotion()
{
    return reinterpret_cast<hkpMotion*>(&m_motion);
}

inline const hkpMotion* hkpEntity::getMotion() const
{
    return reinterpret_cast<const hkpMotion*>(&m_motion);
}

inline hkpSimulationIsland* hkpEntity::getSimulationIsland() const
{
    return m_simulationIsland;
}

hkpAction* hkpEntity::getAction(int i)
{
    return m_actions[i];
}

int hkpEntity::getNumActions() const
{
    return m_actions.getSize();
}

#if !defined(HK_PLATFORM_SPU)

inline const hkSmallArray<hkpEntityListener*>& hkpEntity::getEntityListeners() const
{
#ifdef HK_DEBUG_MULTI_THREADING
    checkReadOnly();
#endif
    if ( !m_extendedListeners )
    {
        m_extendedListeners = new ExtendedListeners;
    }
    return m_extendedListeners->m_entityListeners;
}

inline const hkSmallArray<hkpEntityActivationListener*>& hkpEntity::getEntityActivationListeners() const
{
#ifdef HK_DEBUG_MULTI_THREADING
    checkReadOnly();
#endif
    if ( !m_extendedListeners )
    {
        m_extendedListeners = new ExtendedListeners;
    }
    return m_extendedListeners->m_activationListeners;
}

#endif

inline const hkSmallArray<hkpContactListener*>& hkpEntity::getContactListeners() const
{
#ifdef HK_DEBUG_MULTI_THREADING
    checkReadOnly();
#endif
    return m_contactListeners;
}

inline bool hkpEntity::areContactListenersAdded() const
{
    return m_contactListeners.getSize() > 0;
}

inline hkUint16 hkpEntity::getContactPointCallbackDelay() const
{
    return m_contactPointCallbackDelay;
}

inline void hkpEntity::setContactPointCallbackDelay( hkUint16 delay )
{
    m_contactPointCallbackDelay = delay;
}

inline hkpMaterial& hkpEntity::getMaterial()
{
    return m_material;
}

inline const hkpMaterial& hkpEntity::getMaterial() const
{
    return m_material;
}

inline hkdBreakableBody* hkpEntity::getBreakableBody() const
{
    return reinterpret_cast<hkdBreakableBody*>(m_breakableBody);
}


inline hkBool hkpEntity::isFixed() const
{
    return getMotion()->m_type == hkpMotion::MOTION_FIXED;
}

hkBool hkpEntity::isFixedOrKeyframed() const
{
    return (getMotion()->m_type == hkpMotion::MOTION_FIXED) || (getMotion()->m_type == hkpMotion::MOTION_KEYFRAMED);
}

inline hkUint32 hkpEntity::getUid() const
{
    return m_uid;
}

const hkSmallArray<struct hkConstraintInternal>&  hkpEntity::getConstraintMasters() const
{
#ifdef HK_DEBUG_MULTI_THREADING
    return getConstraintMastersImpl();
#else
    return m_constraintsMaster;
#endif
}

hkSmallArray<struct hkConstraintInternal>&  hkpEntity::getConstraintMastersRw()
{
#ifdef HK_DEBUG_MULTI_THREADING
    return getConstraintMastersRwImpl();
#else
    return m_constraintsMaster;
#endif
}

const hkArray< hkViewPtr<hkpConstraintInstance> >&  hkpEntity::getConstraintSlaves() const
{
#ifdef HK_DEBUG_MULTI_THREADING
    return getConstraintSlavesImpl();
#else
    return m_constraintsSlave;
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
