// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Returns the breaking threshold for the given shape key

hkBool HK_CALL hkpBreakableShape::getShapeKeyStrength(const hkpBreakableShape* rootBreakableShapeSpu, const hkpBreakableMaterial* rootMaterialSpu, hkpShapeKey shapeKey, hkUFloat8& shapeKeyStrengthOut)
{
    HK_ASSERT_NO_MSG(0x71e403ca, rootMaterialSpu);

    // Get the sub-material if any, for the given shape key
    // If the shape key is invalid, we'll use the root material; we cannot locate the proper child anyway.
    if ( shapeKey != HK_INVALID_SHAPE_KEY )
    {
        // Get physics shape pointer on PPU
        const hkcdShape* physicsShapePpu = rootBreakableShapeSpu->getPhysicsShape();
        return hkpBreakableMaterialUtil::getSubShapeMaterialStrength(rootMaterialSpu, physicsShapePpu, shapeKey, shapeKeyStrengthOut);
    }

    // Return the root material strength
    if ( rootMaterialSpu->isBreakable() )
    {
        rootMaterialSpu->getEncodedMaterialStrength(shapeKeyStrengthOut);
        return true;
    }

    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
