// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Destruction/BreakableMaterial/hkpBreakableMaterial.h>
#include <Physics2012/Dynamics/Destruction/BreakableMaterial/hkpBreakableMaterialUtil.h>

    //
    /// Base class for a Destruction breakable shape. Contains a physics shape and a material that controls how the shape handles impacts (i.e. breaks / deforms).
class HK_EXPORT_PHYSICS_2012 hkpBreakableShape : public hkReferencedObject
{
    // +version(1)

    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE_CLASS);

    public:

            /// Constructor
        HK_INLINE hkpBreakableShape(const hkcdShape* physicsShape = HK_NULL, hkpBreakableMaterial* material = HK_NULL)
        :   hkReferencedObject()
        ,   m_physicsShape(physicsShape)
        ,   m_material(material)
        {}

            /// Returns the physics shape.
        HK_INLINE const hkcdShape* getPhysicsShape() const { return m_physicsShape.val(); }

            /// Returns the material.
        HK_INLINE const hkpBreakableMaterial* getMaterial() const { return m_material.val(); }

            /// Returns the material.
        HK_INLINE hkpBreakableMaterial* getMaterial() { return m_material.val(); }

            /// Sets the shape.
        HK_INLINE void setPhysicsShape(const hkcdShape* newPhysicsShape) { m_physicsShape = newPhysicsShape; }

            /// Sets the material.
        HK_INLINE void setMaterial(hkpBreakableMaterial* newMaterial) { m_material = newMaterial; }

            /// Computes the breaking threshold for the given shape key. Returns true if the shape key is breakable, false otherwise.
        static HK_INLINE hkBool HK_CALL getShapeKeyStrength(const hkpBreakableShape* rootBreakableShape, const hkpBreakableMaterial* rootMaterial, hkpShapeKey shapeKey, hkUFloat8& shapeKeyStrengthOut);

    protected:

            /// The physics shape
        hkRefPtr<const hkcdShape> m_physicsShape;

            /// The material controlling the way the shape breaks
        hkRefPtr<hkpBreakableMaterial> m_material;
};

#include <Physics2012/Dynamics/Destruction/BreakableShape/hkpBreakableShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
