// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Destruction/BreakableMaterial/hkpBreakableMaterial.h>

//
//  Called to add multiple shape keys

void hkpBreakableMaterial::ShapeKeyCollector::addShapeKeyBatch(const hkpShapeKey* shapeKeys, int numShapeKeys)
{
    for (int i = 0; i < numShapeKeys; i++)
    {
        addShapeKey(shapeKeys[i]);
    }
}

//
//  Called to add a contiguous range of shape keys, i.e. from shapeKeyBase to shapeKeyBase + n - 1

void hkpBreakableMaterial::ShapeKeyCollector::addContiguousShapeKeyRange(hkpShapeKey baseShapeKey, int numShapeKeys)
{
    for (int i = 0; i < numShapeKeys; i++)
    {
        addShapeKey(baseShapeKey | i);
    }
}

//
//  Sets the default mapping

void hkpBreakableMaterial::setDefaultMapping()
{
    setMapping(MATERIAL_MAPPING_UNKNOWN);
}

//
//  Destructor

hkpBreakableMaterial::~hkpBreakableMaterial()
{
    if ( m_properties && getMemorySizeAndFlags() )
    {
        delete m_properties;
    }

    m_properties = HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
