// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Destruction/BreakableMaterial/hkpBreakableMaterial.h>



    //
    /// Simple breakable material with no sub-materials
class HK_EXPORT_PHYSICS_2012 hkpSimpleBreakableMaterial : public hkpBreakableMaterial
{
    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DESTRUCTION_2012);

        enum
        {
            DEFAULT_FLAGS = hkpBreakableMaterial::MATERIAL_TYPE_SIMPLE |
                            hkpBreakableMaterial::MATERIAL_MAPPING_NONE,
        };

    public:

            /// Constructor
        hkpSimpleBreakableMaterial(hkReal strength = 0.0f);

        void afterReflectNew();

            /// Copy constructor
        hkpSimpleBreakableMaterial(const hkpSimpleBreakableMaterial& other);

    public:

#ifndef HK_PLATFORM_SPU

            /// Clones the given material
        virtual hkpBreakableMaterial* duplicate();

            /// Sets the default mapping
        virtual void setDefaultMapping();

            /// Returns the material set on the given shape key
        virtual hkpBreakableMaterial* getShapeKeyMaterial(const hkcdShape* shapePpu, hkpShapeKey shapeKey) const;

#endif
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
