// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Destruction/BreakableMaterial/Simple/hkpSimpleBreakableMaterial.h>

//
//  Constructor

hkpSimpleBreakableMaterial::hkpSimpleBreakableMaterial(hkReal strength)
:   hkpBreakableMaterial(DEFAULT_FLAGS, strength)
{}

void hkpSimpleBreakableMaterial::afterReflectNew()
{
    m_typeAndFlags = DEFAULT_FLAGS;
}

//
//  Copy constructor

hkpSimpleBreakableMaterial::hkpSimpleBreakableMaterial(const hkpSimpleBreakableMaterial& other)
:   hkpBreakableMaterial(other)
{}

//
//  Clones the given material

hkpBreakableMaterial* hkpSimpleBreakableMaterial::duplicate()
{
    return new hkpSimpleBreakableMaterial(*this);
}

//
//  Sets the default mapping

void hkpSimpleBreakableMaterial::setDefaultMapping()
{
    setMapping(hkpBreakableMaterial::MATERIAL_MAPPING_NONE);
}

//
//  Returns the material set on the given shape key

hkpBreakableMaterial* hkpSimpleBreakableMaterial::getShapeKeyMaterial(const hkcdShape* shapePpu, hkpShapeKey shapeKey) const
{
    return const_cast<hkpSimpleBreakableMaterial*>(this);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
