// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_PLATFORM_SPU)
#   include <Common/GeometryUtilities/Spu/hkSpuConfig.h>
#   include <Common/Base/Memory/PlatformUtils/Spu/SpuDmaCache/hkSpu4WayCache.h>
extern class hkSpu4WayCache* g_SpuCollideUntypedCache;
#endif
#include <Physics2012/Dynamics/Destruction/Utilities/hkpDestructionSpuUtil.h>

//
//  Inverse mapping constructor

inline hkpBreakableMultiMaterial::InverseMappingDescriptor::InverseMappingDescriptor()
:   m_offset(0)
,   m_numKeys(0)
{}

//
//  Returns the i-th sub-material. The returned pointer is on PPU.

inline const hkpBreakableMaterial* hkpBreakableMultiMaterial::getSubMaterial(MaterialId subMaterialIndex) const
{
    // Return the PPU sub-material pointer.
#ifdef HK_PLATFORM_SPU
    return hkGetArrayElemUsingCacheHalfSizeOutOfLine< hkRefPtr<hkpBreakableMaterial> >(m_subMaterials.begin(), subMaterialIndex, g_SpuCollideUntypedCache, HK_SPU_UNTYPED_CACHE_LINE_SIZE)->val();
#else
    return m_subMaterials[subMaterialIndex];
#endif
}

#ifndef HK_PLATFORM_SPU

//
//  Returns the inverse mapping

inline const hkpBreakableMultiMaterial::InverseMapping* hkpBreakableMultiMaterial::getInverseMapping() const
{
    return m_inverseMapping;
}

//
//  Clears the inverse mapping

inline void hkpBreakableMultiMaterial::clearInverseMapping()
{
    m_inverseMapping = HK_NULL;
}

//
//  Sets the i-th sub-material

inline void hkpBreakableMultiMaterial::setSubMaterial(MaterialId subMaterialIndex, hkpBreakableMaterial* subMaterial)
{
    m_subMaterials[subMaterialIndex] = subMaterial;
}

#endif  //  !HK_PLATFORM_SPU

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
