// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Destruction/BreakableMaterial/MultiMaterial/hkpBreakableMultiMaterial.h>
#include <Physics2012/Collide/Shape/Compound/Collection/List/hkpListShape.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>




    //
    /// Multi-material specialized to work with a list shape. The direct mapping from shape key to material index is stored in
    /// ChildInfo::m_shapeInfo, with no extra memory cost.
class HK_EXPORT_PHYSICS_2012 hkpListShapeBreakableMaterial : public hkpBreakableMultiMaterial
{
    public:
        HK_DECLARE_CLASS(hkpListShapeBreakableMaterial, New, Reflect, BypassCtor);

    public:

            /// Constructor
        hkpListShapeBreakableMaterial(const hkArray<hkpBreakableMaterial*>& subMaterials, hkReal strength = 0.0f);

            /// Copy constructor
        hkpListShapeBreakableMaterial(const hkpListShapeBreakableMaterial& other);


    public:

#ifndef HK_PLATFORM_SPU

            /// Clones the given material
        virtual hkpBreakableMaterial* duplicate();

            /// Sets the default mapping
        virtual void setDefaultMapping();

            /// Returns the index of the sub-material belonging to the given sub-shape.
        virtual MaterialId getSubShapeMaterialIndex(const hkcdShape* rootShape, hkUint32 subShapeId) const;

            /// Returns the material set on the given shape key
        virtual hkpBreakableMaterial* getShapeKeyMaterial(const hkcdShape* shapePpu, hkpShapeKey subShapeKey) const;

            /// Disables a set of sub-shapes based on their sub-material Id
        virtual void disableSubShapes(hkcdShape* rootShape, const MaterialId* subMaterialIndices, int numSubMaterialIndices);

            /// Collects the shape keys belonging to the given sub-shape
        virtual void getShapeKeysForSubShapes(const hkcdShape* rootShape, const hkUint32* subShapeIdPtr, int numSubShapeIds, ShapeKeyCollector* collector) const;

            /// Appends the sub-material indices set on the given sub-shapes to the given array
        virtual void getSubShapeMaterialIndices(const hkcdShape* rootShape, const hkArray<hkUint32>& subShapeIdsIn, hkArray<MaterialId>& subMaterialsOut) const;

    protected:

            /// Retrieves a list shape from the given shape
        static HK_INLINE const hkpListShape* HK_CALL getListShape(const hkcdShape* shape);

#endif
};

#ifndef HK_PLATFORM_SPU
#include <Physics2012/Dynamics/Destruction/BreakableMaterial/MultiMaterial/ListShape/hkpListShapeBreakableMaterial.inl>
#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
