// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Constraint/hkpConstraintInstance.h>
#include <Physics/Constraint/Data/hkpConstraintData.h>


class HK_EXPORT_PHYSICS_2012 hkpConstraintOwner : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DYNAMICS);

        inline void addConstraintInfo( hkpConstraintInstance* constraint, hkpConstraintInfo& delta )
        {
            HK_ON_DEBUG_MULTI_THREADING( checkAccessRw() );
            if ( constraint->m_internal )
            {
                m_constraintInfo.add( delta );
                constraint->m_internal->addConstraintInfo( delta );
                    // we have to do this because the delta might not include the full modifier list, see HVK-3602
                m_constraintInfo.m_maxSizeOfSchema = hkMath::max2( int(m_constraintInfo.m_maxSizeOfSchema), int(constraint->m_internal->m_sizeOfSchemas) );
            }
        }

        inline void subConstraintInfo( hkpConstraintInstance* constraint, hkpConstraintInfo& delta )
        {
            HK_ON_DEBUG_MULTI_THREADING(checkAccessRw());
            if ( constraint->m_internal )
            {
                m_constraintInfo.sub( delta );
                constraint->m_internal->subConstraintInfo( delta );
            }
        }

    public:

        virtual void addConstraintToCriticalLockedIsland(      hkpConstraintInstance* constraint ) {}
        virtual void removeConstraintFromCriticalLockedIsland( hkpConstraintInstance* constraint ) {}
        virtual void addCallbackRequest( hkpConstraintInstance* constraint, int request ) {}

        virtual void checkAccessRw() {}

    public:

        hkpConstraintInfo m_constraintInfo;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
