// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Solve/hkpSolve.h>
#include <Physics/ConstraintSolver/Constraint/hkpConstraintQueryIn.h>

#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>

class hkpConstraintInstance;
class hkpEntity;
class hkStepInfo;
class hkpVelocityAccumulator;
class hkpSimulationIsland;
class hkpVelocityAccumulator;


struct HK_EXPORT_PHYSICS_2012 hkpConstraintSchemaInfo
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpConstraintSchemaInfo );

    hkpConstraintInstance*     m_constraint;
    hkpJacobianSchema* m_schema;
    hkReal            m_allowedPenetrationDepth;
};

struct hkpBuildJacobianTaskHeader;

    // setting this value so that hkpBuildJacobianTask ~< 2^x
struct HK_EXPORT_PHYSICS_2012 hkpBuildJacobianTask
{
#if (HK_POINTER_SIZE == 4)
#   if defined (HK_PLATFORM_HAS_SPU)
        enum { MAX_NUM_ATOM_INFOS = 120 }; // For testing this should be reduced to e.g. 2
#   else
        enum { MAX_NUM_ATOM_INFOS = 144 }; // For testing this should be reduced to e.g. 2
#   endif
#else
        enum { MAX_NUM_ATOM_INFOS = 80 }; // Might need to be corrected
#endif

    struct AtomInfo
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpBuildJacobianTask::AtomInfo );

        // atom ptr
        hkpConstraintAtom*      m_atoms;
        hkpConstraintInstance*  m_instance;
        hkpConstraintRuntime*   m_runtime;
        const hkTransform*      m_transformA;
        const hkTransform*      m_transformB;

        // atom size -- can be hkUint16 as long as we don't do chains in SPU's
        hkUint16 m_atomsSize;

        hkUint16 m_runtimeSize;

        // accumulator indices --  still needed by build Jacobians, but might be replaced by the alternative offsets below (for _platform_has_spu)
        // these indices are used for building Jacobians
        hkUint16 m_accumulatorIndexA;
        hkUint16 m_accumulatorIndexB;
    };

    inline hkpBuildJacobianTask();

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT, hkpBuildJacobianTask );
    HK_ALIGN128( hkpBuildJacobianTask*) m_next ;

    hkpBuildJacobianTaskHeader* m_taskHeader;

    const hkpVelocityAccumulator*m_accumulators;
    hkpJacobianSchema*          m_schemas;
    hkpJacobianSchema*          m_schemasOfNextTask;

    int m_numAtomInfos;
    AtomInfo m_atomInfos[MAX_NUM_ATOM_INFOS];
};

struct HK_EXPORT_PHYSICS_2012 hkpBuildJacobianTaskCollection
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpBuildJacobianTaskCollection );

    hkpBuildJacobianTaskCollection()
    {
        m_buildJacobianTasks = HK_NULL;
        m_numBuildJacobianTasks = 0;
#if defined(HK_PLATFORM_HAS_SPU)
        m_ppuOnlyBuildJacobianTasks = HK_NULL;
        m_numPpuOnlyBuildJacobianTasks = 0;
#endif
        m_callbackConstraints = HK_NULL;
        m_numCallbackConstraints = 0;
    }

    // this is a list to the tasks (formerly 'batches') which can be executed by the solver
    // during buildJacobiansTasks this variable is owned and created by the thread which initiated the buildJacobiansTasks.
    // This variable is read only once initialized
    struct hkpBuildJacobianTask* m_buildJacobianTasks;
    int                          m_numBuildJacobianTasks;

#if defined(HK_PLATFORM_HAS_SPU)
    // a list of constraints which can only be setup on PPU
    struct hkpBuildJacobianTask* m_ppuOnlyBuildJacobianTasks;
    int                          m_numPpuOnlyBuildJacobianTasks;
#endif

        /// This links a constraint which needs to fire a callback with its corresponding buildJacobianTask.
        /// This allows a contactPointCallback to make changes.
    struct CallbackPair
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpBuildJacobianTaskCollection::CallbackPair);
        const hkConstraintInternal* m_callbackConstraints;
        hkpBuildJacobianTask::AtomInfo* m_atomInfo;
    };

    // a list of constraints that need to fire callbacks before the Jacobian setup job is executed
    CallbackPair* m_callbackConstraints;
    int m_numCallbackConstraints;
};

struct HK_EXPORT_PHYSICS_2012 hkpSolveJacobiansTaskCollection
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpSolveJacobiansTaskCollection );

    hkpSolveJacobiansTaskCollection() : m_firstSolveJacobiansTask(HK_NULL), m_firstBatchSize(0) {}

    struct hkpSolveConstraintBatchTask* m_firstSolveJacobiansTask;
    hkUint16 m_firstBatchSize;
};

    // Rules for reading and writing:
    // All mutables can only be accessed (read or write) in single threaded mode
    // All other variables can be accessed read only
    // this structure is allocated in buildJacobianTasksJob
    // and deleted in the broadphase job
struct HK_EXPORT_PHYSICS_2012 hkpBuildJacobianTaskHeader
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT, hkpBuildJacobianTaskHeader );

        HK_INLINE hkpBuildJacobianTaskHeader() : m_referenceCount(1), m_numIslandsAfterSplit(1), m_buffer(0), m_bufferSize(0), m_bufferCapacity(0) {}

        HK_INLINE ~hkpBuildJacobianTaskHeader() {}

    public:

            // can only be accessed if the job queue is locked
        HK_ALIGN16( mutable int   m_openJobs );

            // the open jobs before triggering the broadphase, jobs which modify this variable:
            //   - DYNAMICS_JOB_SPLIT_ISLAND
            //   - DYNAMICS_JOB_INTEGRATE_MOTION
            // can only be accessed if the job queue is locked
        mutable int m_numUnfinishedJobsForBroadphase;

            // set to true by the finish job function,
            // maybe set to 0 by the integrate motion jobs
            // this variable will be examined by the broadphase, which will optionally deactivate the island
        mutable int m_islandShouldBeDeactivated;

            // the broadphase job should delete this structure.
            // As the split job can create several islands, we get several broadphase jobs for this structure.
            // The last broadphase job should delete this.
            // You are only allowed to access this variable using hkAtomic::exchangeAdd32()
        mutable long m_referenceCount;

            // the number of islands which came out of a split island job
        mutable int m_numIslandsAfterSplit;

            //
            //  constraints info
            //
        void* m_buffer;

        int   m_bufferSize;

        int   m_bufferCapacity;

            // flag set to 1 by the export job to indicate that the export is finished,
            // later this flag is set to 2 to indicate that the solver callbacks have been fired
        hkChar m_exportFinished;

            // this is set to true, if the island requests a split and a split island job should be created
        hkChar m_splitCheckRequested;

            // Serial Id of this job
        HK_ON_DETERMINISM_CHECKS_ENABLED( hkUint16 m_sidForNextJobType; )

            // a linked list of breached contact forces. Set by
            //    - on spu by finishDynamicsJob in the export job
            //    - on spu by the solve job for single threaded islands
            //    - on ppu by finishDynamicsJob
        mutable hkpImpulseLimitBreachedHeader* m_impulseLimitsBreached;

            // Aligned to be copied directly into an spu job: see hkpSolveApplyGravityJob::hkpSolveApplyGravityJob
        HK_ALIGN16( hkpVelocityAccumulator* m_accumulatorsBase );
        hkpVelocityAccumulator* m_accumulatorsEnd;

        hkObjectIndex m_numApplyGravityJobs;
        hkObjectIndex m_numIntegrateVelocitiesJobs;

        hkpJacobianSchema*      m_schemasBase;
        hkpSolverElemTemp*      m_solverTempBase;

        hkInt32  m_numSolverResults;
        hkInt32  m_numSolverElemTemps;

            // pointer to the ppu version of a hkpConstraintQueryIn
        const hkpConstraintQueryIn*    m_constraintQueryIn;

            // the entities of the original islands, if m_newSplitIslands is empty,
            // these entities are identical to the island entities, else they have
            // to be freed when the task header is deleted.
        hkpEntity*const* m_allEntities;

        hkObjectIndex   m_numAllEntities;
        hkObjectIndex   m_entitiesCapacity;

        hkBool m_solveInSingleThread;
        hkBool m_solveInSingleThreadOnPpuOnly;

            //
            // variables set if the island is split by the hkSplitIslandJob
            //
#if !defined (HK_PLATFORM_SPU)
        hkArray<hkpSimulationIsland*> m_newSplitIslands;
#else
        HK_ALIGN( hkUint8   m_newSplitIslandsDummy[sizeof(hkArray<hkpSimulationIsland*>)],4);
#endif

    public:
        friend struct hkpJobQueueUtils;
        friend struct hkpSingleThreadedJobsOnIsland;

        mutable struct hkpBuildJacobianTaskCollection m_tasks;

        struct hkpSolveJacobiansTaskCollection m_solveTasks;
};


struct HK_EXPORT_PHYSICS_2012 hkpSolveConstraintBatchTask
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT, hkpSolveConstraintBatchTask );

    inline hkpSolveConstraintBatchTask()
    {
        m_next = 0;
        m_isLastTaskInBatch = false;
        m_sizeOfNextBatch = 0;
        m_firstTaskInNextBatch = HK_NULL;
    }

    HK_ALIGN16( hkpSolveConstraintBatchTask*) m_next ;

    // Not used by this job, but needed to pass it to the next job
    hkpBuildJacobianTaskHeader* m_taskHeader;

    hkpVelocityAccumulator*     m_accumulators;
    const hkpJacobianSchema*    m_schemas;
    hkpSolverElemTemp*          m_solverElemTemp;
    hkInt32 m_sizeOfSchemaBuffer;
    hkInt32 m_sizeOfSolverElemTempBuffer;

    hkBool m_isLastTaskInBatch;
    hkUint16 m_sizeOfNextBatch;

    hkpSolveConstraintBatchTask* m_firstTaskInNextBatch;

#   if defined(HK_PLATFORM_HAS_SPU)
    // 20k for schemas;
    //   80 bytes / schema on avg.
    // 250 schemas
    //   4 schemas per constraint on avg.
    // 64 constraints -> 128 accumulators global max.
    /// define if has_spu
    enum { MAX_NUM_ACCUMULATORS_PER_TASK = 128 }; // was 6 : never breach   // 128

    hkObjectIndex m_accumulatorInterIndices[MAX_NUM_ACCUMULATORS_PER_TASK];
    int m_numOfAccumulatorInterIndices;
#   endif

};


struct HK_EXPORT_PHYSICS_2012 hkpConstraintSolverResources
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpConstraintSolverResources );

    template <typename elem>
    struct BufferState
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpConstraintSolverResources::BufferState<elem> );

        elem*      m_begin;
        elem*      m_end;
        elem*      m_current;
        elem*      m_lastProcessed;
    };

        // a struct used to store a backup of the transform
        // in the velocity accumulator, because the solver expects
        // a zero for the sumVelocities
    struct VelocityAccumTransformBackup
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpConstraintSolverResources::VelocityAccumTransformBackup );

        hkRotation m_coreTworldRotation;
    };


    // External data
    hkStepInfo*            m_stepInfo;
    hkpSolverInfo*         m_solverInfo;
    hkpConstraintQueryIn*   m_constraintQueryInput;

    // Memory
    hkpVelocityAccumulator* m_accumulators;
    hkpVelocityAccumulator* m_accumulatorsEnd;
    hkpVelocityAccumulator* m_accumulatorsCurrent;
    VelocityAccumTransformBackup* m_accumulatorsBackup;
    VelocityAccumTransformBackup* m_accumulatorsBackupEnd;

        /// The number of priority classes supported.
        /// There is currently no point in going above three as there are
        /// only three priorities that can map to them (TOI, TOI_HIGHER and
        /// TOI_FORCED).
    static const int NUM_PRIORITY_CLASSES = 3;
    BufferState<hkpJacobianSchema> m_schemas[NUM_PRIORITY_CLASSES];
        /// Map from hkpConstraintInstance::ConstraintPriority to priority
        /// class.
    hkUint8 m_priorityClassMap[hkpConstraintInstance::NUM_PRIORITIES];

    
    //BufferState<hkpSolverElemTemp> m_elemTemp[2];
    
    hkpSolverElemTemp*     m_elemTemp;
    hkpSolverElemTemp*      m_elemTempEnd;
    hkpSolverElemTemp*      m_elemTempCurrent;
    hkpSolverElemTemp*      m_elemTempLastProcessed;
};


    /// some helper functions for using the constraint solver
class HK_EXPORT_PHYSICS_2012 hkpConstraintSolverSetup
{
    public:
            // solve and integrate a number of rigid bodies. Returns the number of inactive frames
        static int HK_CALL solve(
                            const hkStepInfo& stepInfo, const hkpSolverInfo& solverInfo,
                            hkpConstraintQueryIn& constraintQueryIn, hkpSimulationIsland& island,
                            void* preallocatedBuffer, int preallocatedBufferSize,
                            hkpEntity*const* bodies, int numBodies  );

    public:

            //
            //  Functions used for multithreaded solving
            //
        static int HK_CALL calcBufferSize( hkpSimulationIsland& island );


        static int HK_CALL calcBufferOffsetsForSolve( const hkpSimulationIsland& island, char* bufferIn, int bufferSize, hkpBuildJacobianTaskHeader& taskHeader );

    private:

        static HK_INLINE void HK_CALL _buildAccumulators( const hkStepInfo& info, hkpEntity*const* bodiesIn, int numEntities, hkpVelocityAccumulator* accumOut );

        static HK_INLINE void HK_CALL _buildJacobianElement( const hkConstraintInternal* c, hkpConstraintQueryIn& in, hkpVelocityAccumulator* baseAccum,  class hkpConstraintQueryOut& out );

        static HK_INLINE void HK_CALL _buildJacobianElements( hkpConstraintQueryIn& in,
                                        hkpEntity*const* bodies, int numBodies,
                                        hkpVelocityAccumulator* accusIn,
                                        hkpJacobianSchema* schemaOut,
                                        hkpJacobianSchema* schemaOutEnd,
                                        hkpJacobianSchema* schemaOutB);

    public:

        //
        // Functions used for constraint sub-solving and dynamic feeding of data to the solver
        //
        enum SolverMode
        {
            SOLVER_MODE_PROCESS_ALL,
            SOLVER_MODE_INCREMENTAL_CONTINUE
        };

            /// Acquires the scratchpad and initializes a hkpConstraintSolverResources struct
        static void HK_CALL initializeSolverState(hkStepInfo& stepInfo, hkpSolverInfo& solverInfo, hkpConstraintQueryIn& constraintQueryIn,
            char* buffer, int bufferSize, const hkUint8* priorityClassMap, const hkReal* priorityClassRatios,
            hkpConstraintSolverResources& s);

            /// Releases the scratchpad
        static void HK_CALL shutdownSolver(hkpConstraintSolverResources& s);

            /// Builds accumulators
        static void HK_CALL internalAddAccumulators(hkpConstraintSolverResources& s, hkpEntity*const * entities, int numEntities);

            /// Each constraint gets queried: It produces a few Jacobian elements, returns the number of Jacobians generated
        static void HK_CALL internalAddJacobianSchemas(hkpConstraintSolverResources& s,
                                                hkpConstraintInstance** constraints, int numConstraints,
                                                hkArray<hkpConstraintSchemaInfo>& constraintStatus);

        static void HK_CALL subSolve(hkpConstraintSolverResources& s, SolverMode mode);

            /// This function integrates the rigid bodies by using the data in the linear and angular velocity
            /// field in the accumulators and not the sumLinearVelocity.
            /// The sumLinearVelocities are typically set in the hkSolver::integrateVelocities, however if
            /// you only call hkSolveStepJacobion, this sumLinearVelocities won't be used and you have to use this
            /// function to integrate your rigid bodies.
        static void HK_CALL oneStepIntegrate( const struct hkpSolverInfo& si, const hkStepInfo& info, const hkpVelocityAccumulator* accumulatorsBase, hkpEntity*const* entities, int numEntities );


        static hkBool HK_CALL internalIsMemoryOkForNewAccumulators    (hkpConstraintSolverResources& s, hkpEntity**     entities,    int numEntities);
        static hkBool HK_CALL internalIsMemoryOkForNewJacobianSchemas(hkpConstraintSolverResources& s, hkpConstraintInstance** constraints, int numConstraints);

};


hkpBuildJacobianTask::hkpBuildJacobianTask()
{
    m_numAtomInfos = 0;
    m_schemasOfNextTask = HK_NULL;
    m_next = HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
