// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/Wrapper/hkpWrappedConstraintData.h>
#include <Physics/Constraint/Atom/Bridge/hkpBridgeConstraintAtom.h>




/// This is a wrapper class around constraints intended to allow the user to make a constraint softer.
/// Important: This malleable constraint does not affect the angular limit and angular motor components of a constraint.
class HK_EXPORT_PHYSICS_2012 hkpMalleableConstraintData : public hkpWrappedConstraintData
{
    //+version(1)
    public:

        HK_DECLARE_CLASS(hkpMalleableConstraintData, New, Reflect, BypassCtor);

            /// The constraint to be 'softened' should be passed in - its ref count will be incremented.
            ///
            /// The malleable constraint essentially wraps another constraint. A reference
            /// is added to the constraint passed in (and removed upon destruction).
            /// NOTE: Instead of adding the original constraint to the world, you should
            /// add this malleable constraint. Do not add both constraints.
        hkpMalleableConstraintData(hkpConstraintData* constraintData);

            /// Set the strength of the contained constraint.
            /// The value should be in the range 0 (disabled) to 1 (full strength).
        void setStrength(const hkReal s);

            /// Get the strength value for this constraint
        hkReal getStrength() const;

            // hkpConstraintData interface implementation
        virtual int getType() const HK_OVERRIDE;

            // hkpConstraintData interface implementation
        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const HK_OVERRIDE;

        /// Deep-clones the constraint
        virtual hkpWrappedConstraintData* deepClone() const HK_OVERRIDE;

    public:

        struct hkpBridgeAtoms m_atoms;

        hkReal m_strength;

            // Internal functions
        virtual void buildJacobian( const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out ) HK_OVERRIDE;

    public:

        void afterReflectNew();
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
